/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.buildings;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.TpmapEntity;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public abstract class Building
extends TpmapEntity {
    public static final int BUILDING_STATUS_USURP = 1;
    public static final int BUILDING_STATUS_LIB = 2;
    public static final Color nameColor = Color.valueOf("E0C96D");
    protected final Assets assets = Assets.getInstance();
    protected final WindowManager windowManager = WindowManager.getInstance();
    protected final TextureAtlas atlas = (TextureAtlas)this.assets.get("buildings/buildings.atlas");
    protected final Storage storage = Storage.getInstance();
    protected Array<Drawable> buildingStates = new Array();
    protected Image lighting;
    protected Table name;
    protected Label nameLabel;
    protected Image texture = new Image();
    protected int currentStatus = 2;
    protected Static.StaticBuilding data;
    protected Static.StaticFaction fraction;
    protected GridPoint2 point;
    protected Array<TiledNode> border = new Array(8);
    protected Static.StaticBuildingType buildingType;

    public Building(Static.StaticBuilding data) {
        this.data = data;
        this.fraction = this.storage.faction.get(data.getFactionId());
        this.point = Tpmap.getPosition(data.getPosition());
        this.setPosition(this.point.x * 64, this.point.y * 64);
        this.setPriority(5);
        this.lighting = new Image(this.atlas.findRegion("building_lighting"));
        this.lighting.setPosition(-1.0f, -65.0f);
        this.buildingType = this.storage.buildingType.get(data.getBuildingTypeId());
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().centryGothicBold14, nameColor);
        this.name = new Table();
        this.name.setBackground(this.assets.getDrawable(this.atlas, "name_building_bg"));
        this.nameLabel = new Label((CharSequence)this.buildingType.getName(), style);
        this.name.add(this.nameLabel).expand();
        this.setSize(128.0f, 128.0f);
    }

    public void updateStatus(int status) {
        int frameUsurp;
        if (this.currentStatus == status || this.fraction == null) {
            return;
        }
        Static.StaticZone zone = this.storage.zone.get(this.data.getZoneId());
        PlanetData planet = this.storage.planet.get(zone.getPlanetId());
        if (!this.storage.planet.isHomePlanet(planet)) {
            return;
        }
        int n = frameUsurp = this.storage.faction.isOseon(this.fraction.getCode()) ? 1 : 2;
        if (status == 2) {
            this.texture.setDrawable(this.buildingStates.first());
        } else if (status == 1) {
            this.texture.setDrawable(this.buildingStates.get(frameUsurp));
        }
        this.texture.pack();
        this.currentStatus = status;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (x >= this.getX() && y >= this.getY() && x <= this.getX() + 128.0f && y <= this.getY() + 128.0f) {
            return this;
        }
        return super.hit(x, y, touchable);
    }

    public void select() {
        this.addActorAt(0, this.lighting);
    }

    public void unselect() {
        this.lighting.remove();
    }

    public void applyBorder(Tpmap map) {
        this.border.add(map.getNode(this.point.x - 1, this.point.y), map.getNode(this.point.x - 1, this.point.y + 1));
        this.border.add(map.getNode(this.point.x + 2, this.point.y), map.getNode(this.point.x + 2, this.point.y + 1));
        this.border.add(map.getNode(this.point.x, this.point.y + 1), map.getNode(this.point.x + 1, this.point.y + 1));
        this.border.add(map.getNode(this.point.x, this.point.y - 2), map.getNode(this.point.x + 1, this.point.y - 2));
    }

    public TiledNode findNearestNode(TiledNode startNode) {
        TiledNode nearestNode = null;
        int minDistance = Integer.MAX_VALUE;
        for (TiledNode node : this.border) {
            int distance = Math.abs(node.x - startNode.x) + Math.abs(node.y - startNode.y);
            if (distance >= minDistance || !node.walkable) continue;
            nearestNode = node;
            minDistance = distance;
        }
        return nearestNode;
    }

    public abstract void action();

    public boolean inNode(TiledNode node) {
        return !(this.point.y - 1 != node.y && this.point.y - 1 - 1 != node.y || this.point.x - 1 != node.x && this.point.x - 1 + 1 != node.x);
    }

    public GridPoint2 getCell() {
        return this.point;
    }

    public Static.StaticBuilding getData() {
        return this.data;
    }
}

