/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.buildings;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.windows.citadel.CitadelWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import packet.Static;

public class Citadel
extends Building {
    private Model model = Model.getInstance();

    public Citadel(Static.StaticBuilding data) {
        super(data);
        Array<TextureRegion> regions = this.assets.extractRegions(this.atlas, "citadel");
        for (TextureRegion r : regions) {
            this.buildingStates.add(new TextureRegionDrawable(r));
        }
        this.texture.setDrawable((Drawable)this.buildingStates.first());
        this.texture.setPosition(-34.0f, -64.0f);
        this.texture.pack();
        this.addActor(this.texture);
        this.name.pack();
        this.name.setPosition(64.0f - this.name.getWidth() / 2.0f, 180.0f);
        this.addActor(this.name);
    }

    @Override
    public void action() {
        Static.StaticBuildingType buildingType = this.storage.buildingType.get(this.data.getBuildingTypeId());
        AvatarData avatar = Model.getInstance().player.selectedAvatar;
        if (this.data.getFactionId() != avatar.fractionId) {
            if (avatar.worldStatus.fractionIsOccupied(this.data.getFactionId())) {
                int needWins = 3;
                switch (avatar.level) {
                    case 7: {
                        needWins = 1;
                        break;
                    }
                    case 8: {
                        needWins = 2;
                    }
                }
                String text = this.model.lang.format("window.citadel.captured", needWins, 6 - avatar.fractionStatus.numInvaders);
                WarningWindow warningWindow = new WarningWindow(WarningWindow.Type.INFO, buildingType.getName(), text, "Ok");
                this.windowManager.open(warningWindow, true);
            } else {
                String text = "\u0417\u0430\u0445\u0432\u0430\u0442\u0438\u0442\u0435 \u0446\u0438\u0442\u0430\u0434\u0435\u043b\u044c \u0438 \u0434\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0443\u0442\u0438 \u043d\u0430 \u043f\u043b\u0430\u043d\u0435\u0442\u0443 \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0433\u0438\u043b\u044c\u0434\u0438\u0438 \u043e\u043f\u0443\u0441\u0442\u043e\u0448\u0438\u0442\u0435\u043b\u0435\u0439. \u041a\u043e\u043c\u0430\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u0448\u0435\u0439 \u0444\u0440\u0430\u043a\u0446\u0438\u0438 \u0432\u043e\u0437\u043d\u0430\u0433\u0440\u0430\u0434\u0438\u0442 \u0432\u0430\u0441 \u0437\u0430 \u043a\u0430\u0436\u0434\u0443\u044e \u043f\u043e\u0431\u0435\u0434\u0443 \u043d\u0430 \u043f\u043b\u0430\u043d\u0435\u0442\u0435 \u0432\u0440\u0430\u0433\u0430!";
                final WarningWindow warningWindow = new WarningWindow(WarningWindow.Type.INFO, buildingType.getName(), text, "\u0417\u0430\u0445\u0432\u0430\u0442\u0438\u0442\u044c");
                warningWindow.setActionlistener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        Commander.getInstance().CitadelActionUsurp(Citadel.this.data.getId());
                        warningWindow.closeHandler();
                    }
                });
                this.windowManager.open(warningWindow, true);
            }
        } else if (avatar.worldStatus.fractionIsOccupied(this.data.getFactionId())) {
            String text = "\u0424\u0440\u0430\u043a\u0446\u0438\u044f \u0437\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430, \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0446\u0438\u0442\u0430\u0434\u0435\u043b\u0438 \u0437\u0430\u043a\u0440\u044b\u0442! \u0414\u043b\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u043f\u043b\u0430\u043d\u0435\u0442\u0443.";
            WarningWindow warningWindow = new WarningWindow(WarningWindow.Type.INFO, buildingType.getName(), text, "Ok");
            this.windowManager.open(warningWindow, true);
        } else {
            this.windowManager.open(new CitadelWindow());
        }
    }

    @Override
    public void updateStatus(int status) {
        int frameUsurp;
        if (this.currentStatus == status || this.fraction == null) {
            return;
        }
        int n = frameUsurp = this.storage.faction.isOseon(this.fraction.getCode()) ? 2 : 3;
        if (status == 2) {
            this.texture.setDrawable((Drawable)this.buildingStates.get(this.storage.faction.isOseon(this.fraction.getCode()) ? 0 : 1));
        } else if (status == 1) {
            this.texture.setDrawable((Drawable)this.buildingStates.get(frameUsurp));
        }
        this.currentStatus = status;
    }
}

