/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.buildings;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.Model;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.windows.FractionGateWindow;
import com.tpwar.game.windows.gate.GateWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.storage.planet.PlanetData;
import packet.Fraction;
import packet.Static;
import packet.Transport;

public class Gate
extends Building
implements MessageListener {
    private PlanetData planet;

    public Gate(Static.StaticBuilding data) {
        super(data);
        this.planet = this.storage.planet.get(this.storage.zone.get(data.getZoneId()).getPlanetId());
        if (this.storage.planet.isHomePlanet(this.planet)) {
            this.fraction = this.storage.faction.get(this.planet.factionId);
        }
        Array<TextureRegion> regions = this.assets.extractRegions(this.atlas, "gate");
        for (TextureRegion r : regions) {
            this.buildingStates.add(new TextureRegionDrawable(r));
        }
        this.texture.setDrawable((Drawable)this.buildingStates.first());
        this.texture.setPosition(-16.0f, -54.0f);
        this.texture.pack();
        this.addActor(this.texture);
        Static.StaticZone zone = this.storage.zone.get(data.getZoneId());
        this.nameLabel.setText(this.buildingType.getName() + " \u2116" + zone.getPosition());
        this.name.pack();
        this.name.setPosition(64.0f - this.name.getWidth() / 2.0f, 102.0f);
        this.addActor(this.name);
    }

    @Override
    public void action() {
        if (this.storage.planet.isHomePlanet(this.planet)) {
            Model.getInstance().addListener(this, Cmd.GateStatsList.getCode());
            Commander.getInstance().GetGateStats();
        } else {
            GateWindow wnd = new GateWindow(this.data);
            this.windowManager.open(wnd);
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case GateStatsList: {
                Model.getInstance().removeListeners(this);
                this.windowManager.open(new FractionGateWindow(Fraction.GateStatsList.parseFrom(msg.getData())));
            }
        }
    }
}

