/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.buildings;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.game.windows.workshop.WorkshopWindow;
import packet.Static;

public class Workshop
extends Building {
    public Workshop(Static.StaticBuilding data) {
        super(data);
        Array<TextureRegion> regions = this.assets.extractRegions(this.atlas, "workshop");
        for (TextureRegion r : regions) {
            this.buildingStates.add(new TextureRegionDrawable(r));
        }
        this.texture.setDrawable((Drawable)this.buildingStates.first());
        this.texture.setPosition(-40.0f, -64.0f);
        this.texture.pack();
        this.addActor(this.texture);
        this.name.pack();
        this.name.setPosition(64.0f - this.name.getWidth() / 2.0f, 146.0f);
        this.addActor(this.name);
    }

    @Override
    public void action() {
        AvatarData avatar = Model.getInstance().player.selectedAvatar;
        if (avatar.worldStatus.fractionIsOccupied(this.data.getFactionId())) {
            String title = this.storage.buildingType.get(this.data.getBuildingTypeId()).getName();
            String text = "\u0424\u0440\u0430\u043a\u0446\u0438\u044f \u0437\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430, \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043c\u0430\u0441\u0442\u0435\u0440\u0441\u043a\u043e\u0439 \u0437\u0430\u043a\u0440\u044b\u0442! \u0414\u043b\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u043f\u043b\u0430\u043d\u0435\u0442\u0443.";
            this.windowManager.open(new WarningWindow(WarningWindow.Type.INFO, title, text, "\u041e\u043a"));
        } else {
            this.windowManager.open(new WorkshopWindow());
        }
    }
}

