/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class AnimatedObject
extends Actor {
    private Animation<? extends TextureRegion> animation;
    private float time = 0.0f;
    private boolean playing = false;
    private TextureRegion region;

    public AnimatedObject(TextureRegion region) {
        this.region = region;
    }

    public AnimatedObject(Animation<TextureRegion> animation) {
        this(animation.getKeyFrame(0.0f));
        this.animation = animation;
        this.playing = true;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.playing) {
            this.region = this.animation.getKeyFrame(this.time += Gdx.graphics.getDeltaTime());
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        batch.draw(this.region, this.getX(), this.getY(), (float)this.region.getRegionWidth(), (float)this.region.getRegionHeight());
    }

    public void setRegion(TextureRegion region) {
        this.region = region;
    }

    public void play() {
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void stop() {
        this.playing = false;
        this.time = 0.0f;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float getTime() {
        return this.time;
    }

    public boolean isAnimationFinished() {
        return this.animation.isAnimationFinished(this.time);
    }

    public Animation<? extends TextureRegion> getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation<? extends TextureRegion> animation) {
        this.animation = animation;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }
}

