/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Queue;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.maps.entity.MapAvatar;
import com.tpwar.game.maps.entity.Skin;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.net.Commander;

public class Avatar
extends MapAvatar {
    private Commander commander = Commander.getInstance();
    private Queue<TiledNode> path = new Queue();
    private Building building;
    private boolean lockMove;
    private int lastPosition;

    public Avatar(AvatarData avatar, Tpmap map, Skin skin) {
        super(avatar, map, skin);
        this.lastPosition = avatar.position;
        Image highlight = new Image(this.elements.findRegion("avatar_highlight"));
        highlight.setPosition(5.0f, 8.0f);
        this.addActorAt(0, highlight);
    }

    public void addPath(TiledNode node) {
        if (this.avatar.position == node.position || (this.path.size == 2 || this.path.size == 1) && this.path.first().hasZone() || this.lockMove) {
            return;
        }
        if (this.path.size == 0 && this.offset == 0) {
            this.next(node);
        } else {
            this.path.addLast(node);
        }
    }

    protected void next(TiledNode node) {
        if (node.leftZoneId > 0L) {
            this.lockMove();
            this.commander.MoveToZone(node.leftZoneId);
            this.setX(1344.0f);
            this.position.x += 19;
            this.skin.walkLeft();
            this.direction = MapAvatar.Direction.LEFT;
            this.offset = 64;
            int newX = 19;
            int newY = node.y;
            node = this.map.getNode(newX, newY);
            this.lastPosition = this.avatar.position;
            this.avatar.position = node.position;
            this.stopMove();
            return;
        }
        if (node.rightZoneId > 0L) {
            this.lockMove();
            this.commander.MoveToZone(node.rightZoneId);
            this.setX(0.0f);
            this.position.x -= 19;
            this.skin.walkRight();
            this.direction = MapAvatar.Direction.RIGHT;
            this.offset = 64;
            int newX = 0;
            int newY = node.y;
            node = this.map.getNode(newX, newY);
            this.lastPosition = this.avatar.position;
            this.avatar.position = node.position;
            this.stopMove();
            return;
        }
        if (this.avatar.position == node.position) {
            if (this.path.size > 0) {
                this.next(this.path.removeFirst());
            }
            return;
        }
        switch (this.avatar.position - node.position) {
            case -1: {
                this.skin.walkRight();
                this.direction = MapAvatar.Direction.RIGHT;
                ++this.position.x;
                break;
            }
            case 1: {
                this.skin.walkLeft();
                this.direction = MapAvatar.Direction.LEFT;
                --this.position.x;
                break;
            }
            case -20: {
                this.skin.walkDown();
                this.direction = MapAvatar.Direction.DOWN;
                --this.position.y;
                break;
            }
            case 20: {
                this.skin.walkUp();
                this.direction = MapAvatar.Direction.UP;
                ++this.position.y;
                break;
            }
            default: {
                this.direction = MapAvatar.Direction.IDLE;
                this.skin.idle();
                this.avatar.position = node.position;
                this.updatePosition(node.position);
                return;
            }
        }
        this.offset = 64;
        this.lastPosition = this.avatar.position;
        this.avatar.position = node.position;
        this.sendPosition(node);
    }

    @Override
    public void updatePosition() {
        this.stopMove();
        this.unlockMove();
        if (this.offset > 0) {
            this.avatar.position = this.lastPosition;
        }
        this.offset = 0;
        super.updatePosition();
        this.map.sortObjects();
    }

    private void sendPosition(TiledNode lastCellInfo) {
        TiledNode node = this.map.getNode(this.position.x, this.position.y);
        this.commander.AvatarActionMove(node.position);
    }

    public void stopMove() {
        this.path.clear();
        this.building = null;
    }

    public void lockMove() {
        this.lockMove = true;
    }

    public void unlockMove() {
        this.lockMove = false;
    }

    @Override
    public void act(float delta) {
        if (this.offset > 0) {
            this.offset -= 2;
            switch (this.direction) {
                case UP: {
                    this.setY(this.getY() + 2.0f);
                    break;
                }
                case DOWN: {
                    this.setY(this.getY() - 2.0f);
                    break;
                }
                case LEFT: {
                    this.setX(this.getX() - 2.0f);
                    break;
                }
                case RIGHT: {
                    this.setX(this.getX() + 2.0f);
                    break;
                }
            }
            if (this.offset == 0) {
                this.map.sortObjects();
                if (this.path.size == 0) {
                    this.direction = MapAvatar.Direction.IDLE;
                    this.skin.idle();
                    if (this.building != null) {
                        this.building.unselect();
                        this.building.action();
                    }
                } else {
                    this.next(this.path.removeFirst());
                }
            }
        }
    }

    public Queue<TiledNode> getPath() {
        return this.path;
    }

    public void setPath(Queue<TiledNode> path) {
        this.path = path;
    }

    public Building getBuilding() {
        return this.building;
    }

    public void setBuilding(Building building) {
        this.building = building;
    }
}

