/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.maps.entity.Skin;

public class AvatarSkin
extends Skin {
    private Animation<? extends TextureRegion> current = null;
    private final Animation<? extends TextureRegion> walkUp;
    private final Animation<? extends TextureRegion> walkDown;
    private final Animation<? extends TextureRegion> walkLeft;
    private final Animation<? extends TextureRegion> walkRight;
    private final TextureRegion idleUp;
    private final TextureRegion idleDown;
    private final TextureRegion idleLeft;
    private final TextureRegion idleRight;

    public AvatarSkin(TextureAtlas atlas, String name) {
        super(atlas.findRegion(name + "_front", 1));
        Array<TextureAtlas.AtlasRegion> front = atlas.findRegions(name + "_front");
        Array<TextureAtlas.AtlasRegion> back = atlas.findRegions(name + "_back");
        Array<TextureAtlas.AtlasRegion> left = atlas.findRegions(name + "_left");
        Array<TextureAtlas.AtlasRegion> right = atlas.findRegions(name + "_right");
        this.idleDown = front.get(0);
        this.idleUp = back.get(0);
        this.idleLeft = left.get(0);
        this.idleRight = right.get(0);
        this.walkDown = this.createAnimation(front, 1, 11, 0.05f, Animation.PlayMode.LOOP);
        this.walkUp = this.createAnimation(back, 1, 11, 0.05f, Animation.PlayMode.LOOP);
        this.walkLeft = this.createAnimation(left, 1, 11, 0.05f, Animation.PlayMode.LOOP);
        this.walkRight = this.createAnimation(right, 1, 11, 0.05f, Animation.PlayMode.LOOP);
        this.setPosition(16.0f, 24.0f);
    }

    @Override
    public void setAnimation(Animation<? extends TextureRegion> animation) {
        super.setAnimation(animation);
        this.current = animation;
        this.setPlaying(true);
    }

    @Override
    public void walkUp() {
        if (this.current != this.walkUp) {
            this.setAnimation(this.walkUp);
        }
    }

    @Override
    public void walkDown() {
        if (this.current != this.walkDown) {
            this.setAnimation(this.walkDown);
        }
    }

    @Override
    public void walkLeft() {
        if (this.current != this.walkLeft) {
            this.setAnimation(this.walkLeft);
        }
    }

    @Override
    public void walkRight() {
        if (this.current != this.walkRight) {
            this.setAnimation(this.walkRight);
        }
    }

    @Override
    public void idle() {
        if (this.current == this.walkUp) {
            this.setRegion(this.idleUp);
        } else if (this.current == this.walkRight) {
            this.setRegion(this.idleRight);
        } else if (this.current == this.walkLeft) {
            this.setRegion(this.idleLeft);
        } else {
            this.setRegion(this.idleDown);
        }
        this.stop();
        this.current = null;
    }
}

