/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.entity.Skin;
import com.tpwar.game.maps.entity.TimeWarpIcon;
import com.tpwar.game.maps.entity.TpmapEntity;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import packet.Static;

public abstract class BaseAvatar
extends TpmapEntity
implements Disposable {
    protected final Storage storage = Storage.getInstance();
    protected final Assets assets = Assets.getInstance();
    protected final Model model = Model.getInstance();
    protected final TextureAtlas elements = (TextureAtlas)this.assets.get("entity/entity_elements.atlas");
    public static boolean showLevelIcon = false;
    protected Skin skin;
    protected TimeWarpIcon timeWarp;
    protected Image shield;
    protected Image treasureMap;
    protected Image guild;
    protected Image level;
    protected Label nickname;
    protected long currentGuildRank;
    public AvatarData avatar;

    public BaseAvatar(AvatarData avatar, Skin skin) {
        this.avatar = avatar;
        this.skin = skin;
        this.setPriority(10);
        this.addActor(skin);
        skin.idle();
        BitmapFont font = this.assets.get("Verdana-Bold_12.ttf", BitmapFont.class);
        Label.LabelStyle nicknameStyle = new Label.LabelStyle(font, Color.valueOf(this.storage.faction.getColor(avatar.fractionId)));
        this.nickname = new Label((CharSequence)avatar.getFullName(), nicknameStyle);
        this.addActor(this.nickname);
        if (this.canShowLevelIcon()) {
            this.level = new Image(this.assets.getDrawable(this.elements, "level" + avatar.level));
            this.level.setUserObject(avatar.level);
            this.addActor(this.level);
        }
        this.updateData();
        Image shadow = new Image(this.elements.findRegion("shadow"));
        shadow.setPosition(2.0f, 2.0f);
        this.addActorAt(0, shadow);
    }

    public void updateData() {
        this.updateTimeWarp();
        this.updateTreasureMap();
        this.updateGuild();
        this.updateShield();
        this.updateName();
    }

    public void updateShield() {
        if (this.avatar.shield > 0L && this.avatar.shield > this.model.getServerTime()) {
            if (this.shield == null) {
                this.shield = new Image(this.elements.findRegion("shield_icon"));
                this.shield.setColor(Color.valueOf(this.storage.faction.getColor(this.avatar.fractionId)));
            }
            this.addActor(this.shield);
        } else if (this.shield != null) {
            this.shield.remove();
        }
    }

    public void updateTimeWarp() {
        if (this.avatar.timeWarpTypeId > 0L) {
            if (this.timeWarp == null) {
                Array<TextureRegion> regions = this.assets.extractRegions(this.elements, "time_warp_icon");
                Array<Drawable> states = new Array<Drawable>(2);
                for (TextureRegion r : regions) {
                    states.add(new TextureRegionDrawable(r));
                }
                this.timeWarp = new TimeWarpIcon(states);
            }
            Static.StaticTimeWarpType timeWarpType = this.storage.timeWarp.get(this.avatar.timeWarpTypeId);
            this.timeWarp.setType(timeWarpType.getCode());
            this.addActor(this.timeWarp);
        } else if (this.timeWarp != null) {
            this.timeWarp.remove();
        }
    }

    public void updateTreasureMap() {
        if (this.avatar.treasureId > 0L) {
            if (this.treasureMap == null) {
                this.treasureMap = new Image(this.elements.findRegion("treasure_map_icon"));
                this.treasureMap.setPosition(-4.0f, 56.0f);
            }
            this.addActor(this.treasureMap);
        } else if (this.treasureMap != null) {
            this.treasureMap.remove();
        }
    }

    public void updateGuild() {
        if (this.avatar.guildId > 0L) {
            Static.StaticGuildRank rank = this.avatar.getGuildRank();
            int frame = GuildStorage.getGuildRankFrame(rank);
            TextureRegion guildTexture = this.assets.extractRegions(this.elements, "guild_icon").get(frame);
            if (this.guild == null) {
                this.guild = new Image(guildTexture);
                this.guild.setPosition(51.0f, 54.0f);
                this.addActor(this.guild);
            } else if ((long)rank.getRank() != this.currentGuildRank) {
                this.guild.setDrawable(new TextureRegionDrawable(guildTexture));
            }
            this.currentGuildRank = rank.getRank();
        } else if (this.guild != null) {
            this.guild.remove();
            this.guild = null;
        }
    }

    protected void updateName() {
        if (this.canShowLevelIcon()) {
            if (!this.model.isItAprilFoolsDay()) {
                this.nickname.setText(this.avatar.getFullNameWithoutLevel());
            } else {
                this.nickname.setText("Dude");
            }
            if (!this.level.getUserObject().equals(this.avatar.level)) {
                this.level.setDrawable(this.assets.getDrawable(this.elements, "level" + this.avatar.level));
            }
        } else if (!this.model.isItAprilFoolsDay()) {
            this.nickname.setText(this.avatar.getFullName());
        } else {
            this.nickname.setText("Dude [" + this.avatar.level + "]");
        }
        this.nickname.pack();
        this.nickname.setPosition(37.0f - (this.nickname.getWidth() + (this.canShowLevelIcon() ? this.level.getWidth() : 0.0f)) / 2.0f, 100.0f);
        float offset = 0.0f;
        if (this.shield != null) {
            this.shield.setY(this.nickname.getY() + (this.nickname.getHeight() - this.shield.getHeight()) / 2.0f);
            this.shield.setX(this.nickname.getX() - this.shield.getWidth() - 3.0f);
            offset = 14.0f;
        }
        if (this.timeWarp != null) {
            this.timeWarp.setY(this.nickname.getY() + (this.nickname.getHeight() - this.timeWarp.getHeight()) / 2.0f);
            this.timeWarp.setX(this.nickname.getX() - this.timeWarp.getWidth() - 2.0f - offset);
        }
        if (this.canShowLevelIcon()) {
            this.level.setPosition(this.nickname.getX() + this.nickname.getWidth() + 2.0f, this.nickname.getY() + (this.nickname.getHeight() - this.level.getHeight()) / 2.0f);
        }
    }

    protected boolean canShowLevelIcon() {
        return showLevelIcon && this.avatar.level <= 11;
    }

    @Override
    public void dispose() {
    }
}

