/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.math.GridPoint2;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.BaseAvatar;
import com.tpwar.game.maps.entity.Skin;

public abstract class MapAvatar
extends BaseAvatar {
    protected final int SPEED = 2;
    protected Tpmap map;
    public GridPoint2 position;
    protected int offset = 0;
    protected Direction direction = Direction.IDLE;

    public MapAvatar(AvatarData avatar, Tpmap map, Skin skin) {
        super(avatar, skin);
        this.map = map;
        this.setPriority(10);
        this.updatePosition(avatar.position);
    }

    public void updatePosition(int position) {
        this.position = Tpmap.getPosition(position);
        this.setPosition(this.position.x * 64, this.position.y * 64);
    }

    public void updatePosition() {
        this.updatePosition(this.avatar.position);
    }

    protected static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        IDLE;

    }
}

