/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.maps.entity.Skin;

public class ModifiedSkin20
extends Skin {
    private Animation<? extends TextureRegion> current = null;
    private Animation<? extends TextureRegion> walkUp;
    private Animation<? extends TextureRegion> walkDown;
    private Animation<? extends TextureRegion> walkLeft;
    private Animation<? extends TextureRegion> walkRight;
    private TextureRegion idleUp;
    private TextureRegion idleDown;
    private TextureRegion idleLeft;
    private TextureRegion idleRight;

    public ModifiedSkin20(Array<TextureRegion> regions) {
        super(regions.get(0));
        this.idleDown = regions.get(0);
        this.idleLeft = regions.get(4);
        this.idleUp = regions.get(12);
        this.idleRight = regions.get(8);
        this.walkDown = this.createAnimation(regions, 0, 4, 0.05f, Animation.PlayMode.LOOP);
        this.walkLeft = this.createAnimation(regions, 4, 4, 0.05f, Animation.PlayMode.LOOP);
        this.walkRight = this.createAnimation(regions, 8, 4, 0.05f, Animation.PlayMode.LOOP);
        this.walkUp = this.createAnimation(regions, 12, 4, 0.05f, Animation.PlayMode.LOOP);
        this.setPosition(10.0f, 25.0f);
    }

    @Override
    public void setAnimation(Animation<? extends TextureRegion> animation) {
        super.setAnimation(animation);
        this.current = animation;
        this.setPlaying(true);
    }

    @Override
    public void walkUp() {
        if (this.current != this.walkUp) {
            this.setAnimation(this.walkUp);
        }
    }

    @Override
    public void walkDown() {
        if (this.current != this.walkDown) {
            this.setAnimation(this.walkDown);
        }
    }

    @Override
    public void walkLeft() {
        if (this.current != this.walkLeft) {
            this.setAnimation(this.walkLeft);
        }
    }

    @Override
    public void walkRight() {
        if (this.current != this.walkRight) {
            this.setAnimation(this.walkRight);
        }
    }

    @Override
    public void idle() {
        if (this.current == this.walkUp) {
            this.setRegion(this.idleUp);
        } else if (this.current == this.walkRight) {
            this.setRegion(this.idleRight);
        } else if (this.current == this.walkLeft) {
            this.setRegion(this.idleLeft);
        } else {
            this.setRegion(this.idleDown);
        }
        this.stop();
        this.current = null;
    }
}

