/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.utils.Queue;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.MapAvatar;
import com.tpwar.game.maps.entity.Skin;

public class OtherAvatar
extends MapAvatar {
    protected Queue<Integer> path = new Queue();

    public OtherAvatar(AvatarData avatar, Tpmap map, Skin skin) {
        super(avatar, map, skin);
    }

    public void addPosition(int position) {
        if (this.avatar.position == position) {
            return;
        }
        if (this.path.size == 0 && this.offset == 0) {
            this.next(position);
        } else {
            this.path.addLast(position);
        }
    }

    protected void next(int position) {
        switch (this.avatar.position - position) {
            case -1: {
                this.skin.walkRight();
                this.direction = MapAvatar.Direction.RIGHT;
                break;
            }
            case 1: {
                this.skin.walkLeft();
                this.direction = MapAvatar.Direction.LEFT;
                break;
            }
            case -20: {
                this.skin.walkDown();
                this.direction = MapAvatar.Direction.DOWN;
                break;
            }
            case 20: {
                this.skin.walkUp();
                this.direction = MapAvatar.Direction.UP;
                break;
            }
            default: {
                this.direction = MapAvatar.Direction.IDLE;
                this.skin.idle();
                this.avatar.position = position;
                this.updatePosition(position);
                return;
            }
        }
        this.offset = 64;
        this.avatar.position = position;
    }

    @Override
    public void act(float delta) {
        if (this.offset > 0) {
            this.offset -= 2;
            switch (this.direction) {
                case UP: {
                    this.setY(this.getY() + 2.0f);
                    break;
                }
                case DOWN: {
                    this.setY(this.getY() - 2.0f);
                    break;
                }
                case LEFT: {
                    this.setX(this.getX() - 2.0f);
                    break;
                }
                case RIGHT: {
                    this.setX(this.getX() + 2.0f);
                    break;
                }
            }
            if (this.offset == 0) {
                this.map.sortObjects();
                if (this.path.size == 0) {
                    this.direction = MapAvatar.Direction.IDLE;
                    this.skin.idle();
                } else {
                    this.next(this.path.removeFirst());
                }
            }
        }
    }

    public Queue<Integer> getPath() {
        return this.path;
    }
}

