/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.entity;

import com.badlogic.gdx.Gdx;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.entity.AvatarSkin;
import com.tpwar.game.maps.entity.MapAvatar;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.net.Cmd;
import com.tpwar.net.Connection;
import packet.Zone;

public class TouchpadAvatar
extends MapAvatar {
    private static final String TAG = TouchpadAvatar.class.getSimpleName();
    private Connection connection = Connection.getInstance();

    public TouchpadAvatar(AvatarData avatar, Tpmap map, AvatarSkin skin) {
        super(avatar, map, skin);
        map.sortObjects();
        Gdx.app.log(TAG, "position" + avatar.position);
    }

    public void move(float x, float y) {
        if (this.offset == 0) {
            float absX = Math.abs(x);
            float absY = Math.abs(y);
            if ((double)absX > 0.25 || (double)absY > 0.25) {
                if (absX > absY) {
                    if (x < 0.0f && this.map.walkable(this.position.x - 1, this.position.y)) {
                        TiledNode cellInfo = this.map.getNode(this.position.x--, this.position.y);
                        this.changeDirection(MapAvatar.Direction.LEFT, cellInfo);
                        this.offset = 64;
                    } else if (x > 0.0f && this.map.walkable(this.position.x + 1, this.position.y)) {
                        TiledNode cellInfo = this.map.getNode(this.position.x++, this.position.y);
                        this.changeDirection(MapAvatar.Direction.RIGHT, cellInfo);
                        this.offset = 64;
                    }
                } else if (y < 0.0f && this.map.walkable(this.position.x, this.position.y + 1)) {
                    TiledNode cellInfo = this.map.getNode(this.position.x, this.position.y++);
                    this.changeDirection(MapAvatar.Direction.DOWN, cellInfo);
                    this.offset = 64;
                } else if (y > 0.0f && this.map.walkable(this.position.x, this.position.y - 1)) {
                    TiledNode cellInfo = this.map.getNode(this.position.x, this.position.y--);
                    this.changeDirection(MapAvatar.Direction.UP, cellInfo);
                    this.offset = 64;
                }
            } else {
                this.changeDirection(MapAvatar.Direction.IDLE, null);
            }
        }
    }

    private void changeDirection(MapAvatar.Direction direction, TiledNode lastCellInfo) {
        if (this.direction != direction) {
            switch (direction) {
                case UP: {
                    this.skin.walkUp();
                    break;
                }
                case DOWN: {
                    this.skin.walkDown();
                    break;
                }
                case LEFT: {
                    this.skin.walkLeft();
                    break;
                }
                case RIGHT: {
                    this.skin.walkRight();
                    break;
                }
                case IDLE: {
                    this.skin.idle();
                    this.direction = direction;
                    return;
                }
            }
            this.direction = direction;
        }
        if (direction != MapAvatar.Direction.IDLE) {
            if (lastCellInfo.leftZoneId > 0L && direction == MapAvatar.Direction.LEFT) {
                Zone.MoveToZone.Builder moveToZone = Zone.MoveToZone.newBuilder();
                moveToZone.setZoneId(lastCellInfo.leftZoneId);
                this.connection.send(Cmd.MoveToZone, moveToZone.build());
                this.setX(1280.0f);
                this.position.x += 20;
            } else if (lastCellInfo.rightZoneId > 0L && direction == MapAvatar.Direction.RIGHT) {
                Zone.MoveToZone.Builder moveToZone = Zone.MoveToZone.newBuilder();
                moveToZone.setZoneId(lastCellInfo.rightZoneId);
                this.connection.send(Cmd.MoveToZone, moveToZone.build());
                this.setX(-64.0f);
                this.position.x -= 20;
            } else {
                TiledNode cellInfo = this.map.getNode(this.position.x, this.position.y);
                Zone.AvatarActionMove.Builder msg = Zone.AvatarActionMove.newBuilder();
                msg.setPosition(cellInfo.position);
                this.connection.send(Cmd.AvatarActionMove, msg.build());
            }
        }
    }

    public void update(float delta) {
        if (this.offset > 0) {
            this.offset -= 2;
            switch (this.direction) {
                case UP: {
                    this.setY(this.getY() + 2.0f);
                    break;
                }
                case DOWN: {
                    this.setY(this.getY() + 2.0f);
                    break;
                }
                case LEFT: {
                    this.setX(this.getX() - 2.0f);
                    break;
                }
                case RIGHT: {
                    this.setX(this.getX() + 2.0f);
                    break;
                }
            }
            if (this.offset == 0) {
                this.map.sortObjects();
            }
        }
    }
}

