/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.pathfinding;

import com.badlogic.gdx.ai.pfa.Connection;
import com.badlogic.gdx.ai.pfa.DefaultGraphPath;
import com.badlogic.gdx.ai.pfa.indexed.IndexedGraph;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.pathfinding.TiledConnection;
import com.tpwar.game.maps.pathfinding.TiledNode;

public class TiledGraph
extends DefaultGraphPath<TiledNode>
implements IndexedGraph<TiledNode> {
    public int width = 22;
    public int height = 17;

    public TiledGraph(Tpmap map) {
        super(374);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.add(map.getNode(x, y));
            }
        }
    }

    public void update() {
        for (int x = 0; x < this.width; ++x) {
            int idx = x * this.height;
            for (int y = 0; y < this.height; ++y) {
                TiledNode node = (TiledNode)this.nodes.get(idx + y);
                node.connections.clear();
                if (x > 0) {
                    this.addConnection(node, -1, 0);
                }
                if (y < this.height - 1) {
                    this.addConnection(node, 0, 1);
                }
                if (x < this.width - 1) {
                    this.addConnection(node, 1, 0);
                }
                if (y <= 0) continue;
                this.addConnection(node, 0, -1);
            }
        }
    }

    private void addConnection(TiledNode node, int x, int y) {
        TiledNode target = this.getNode(node.x + 1 + x, node.y + y + 1);
        if (target != null && target.walkable) {
            this.getConnections(node).add(new TiledConnection(node, target));
        }
    }

    public TiledNode getNode(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return null;
        }
        return (TiledNode)this.nodes.get(x * this.height + y);
    }

    @Override
    public int getIndex(TiledNode node) {
        return node.getIndex();
    }

    @Override
    public int getNodeCount() {
        return this.getCount();
    }

    @Override
    public Array<Connection<TiledNode>> getConnections(TiledNode fromNode) {
        return fromNode.connections;
    }
}

