/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.maps.pathfinding;

import com.badlogic.gdx.ai.pfa.DefaultGraphPath;
import com.badlogic.gdx.ai.pfa.indexed.IndexedAStarPathFinder;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.pathfinding.TiledGraph;
import com.tpwar.game.maps.pathfinding.TiledManhattanDistance;
import com.tpwar.game.maps.pathfinding.TiledNode;

public class TiledPathFinder {
    private TiledGraph graph;
    private TiledManhattanDistance<TiledNode> heuristic = new TiledManhattanDistance();
    private IndexedAStarPathFinder<TiledNode> pathFinder;

    public TiledPathFinder(Tpmap map) {
        this.graph = new TiledGraph(map);
        this.pathFinder = new IndexedAStarPathFinder<TiledNode>(this.graph, false);
    }

    public void updateMoveMap() {
        this.graph.update();
    }

    public DefaultGraphPath<TiledNode> find(int startX, int startY, int endX, int endY) {
        TiledNode start = this.graph.getNode(startX, startY);
        TiledNode end = this.graph.getNode(endX, endY);
        return this.find(start, end);
    }

    public DefaultGraphPath<TiledNode> find(TiledNode start, TiledNode end) {
        DefaultGraphPath<TiledNode> outPath = new DefaultGraphPath<TiledNode>(2);
        this.pathFinder.searchNodePath(start, end, this.heuristic, outPath);
        return outPath;
    }

    public TiledGraph getGraph() {
        return this.graph;
    }
}

