/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.Teleports;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.battle.BattleData;
import com.tpwar.events.EventListener;
import com.tpwar.game.battle.Battlefield;
import com.tpwar.game.hud.BattleHud;
import com.tpwar.game.hud.SelectArtefactListener;
import com.tpwar.game.screens.GameScreen;
import com.tpwar.game.screens.observer.ObserverBlockingListener;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.action.AttackWindow;
import com.tpwar.game.windows.battle.BattleEndObserverWindow;
import com.tpwar.game.windows.battle.BattleEndWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.tutorial.BattleTutorial;
import packet.Static;
import packet.Transport;

public class BattleScreen
extends GameScreen
implements MessageListener,
EventListener<Boolean> {
    private Battlefield battlefield;
    private BattleHud hud;
    private BattleTutorial battleTutorial;
    private Image shadow;
    private boolean showAttackWindow = true;
    private boolean battleIsComplete = false;
    private boolean observationMode;
    private EventListener<GameWindow> closeWindowListener;

    public BattleScreen(Teleports app) {
        super(app);
    }

    @Override
    public void show() {
        super.show();
        this.loadZone();
        this.observationMode = this.model.battle.isObserver(this.model.player.selectedAvatar.id);
        this.battlefield = new Battlefield(this.camera, this.viewport);
        this.battlefield.setX(((float)this.map.getWidth() - this.battlefield.getWidth()) / 2.0f - 42.0f);
        this.battlefield.setY(((float)this.map.getHeight() - this.battlefield.getHeight()) / 2.0f);
        this.battlefield.getDispatcher().addListener(10, this);
        this.battlefield.getDispatcher().addListener(13, this);
        this.battlefield.getDispatcher().addListener(14, this);
        this.mapStage.addActor(this.battlefield);
        this.model.addListener(this, Cmd.BattleData.getCode());
        this.model.addListener(this, Cmd.BattleEventReady.getCode());
        this.model.addListener(this, Cmd.BattleEventRound.getCode());
        this.model.addListener(this, Cmd.BattleEventResult.getCode());
        this.closeWindowListener = new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow data) {
                if (data instanceof BattleEndWindow || data instanceof BattleEndObserverWindow) {
                    BattleScreen.this.commander.BattleActionExit();
                }
            }
        };
        this.windowManager.addListener(2, this.closeWindowListener);
        TextureAtlas textureAtlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
        NinePatchDrawable shadowDrawable = Component.getNinePatchDrawable(textureAtlas, "shadow", 50, 50, 50, 50);
        this.shadow = new Image(shadowDrawable);
        this.shadow.setTouchable(Touchable.disabled);
        this.hudStage.addActor(this.shadow);
        this.hud = new BattleHud();
        this.hudStage.addActor(this.hud);
        this.hud.bottomPanel.startRoundBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BattleScreen.this.hud.bottomPanel.lockButtons();
                BattleScreen.this.hud.bottomPanel.lockArtefacts();
                BattleScreen.this.battlefield.sendAttackRequest();
                BattleScreen.this.battlefield.setArtefact(null, false);
            }
        });
        this.hud.bottomPanel.escapeBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.confirm.escape", "window.confirm.escape.message", "window.confirm.ok");
                wnd.setActionlistener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        BattleScreen.this.commander.BattleActionEscape();
                        wnd.closeHandler();
                    }
                });
                BattleScreen.this.windowManager.open(wnd, true);
            }
        });
        this.hud.bottomPanel.setSelectArtefactListener(new SelectArtefactListener(){

            @Override
            public void clickArtefact(ArtefactData artefactData, boolean selected) {
                BattleScreen.this.battlefield.setArtefact(artefactData, selected);
                BattleScreen.this.hud.bottomPanel.updateArtefacts();
            }
        });
        if (this.observationMode) {
            this.hudStage.addCaptureListener(new ObserverBlockingListener());
            this.hud.showObservationMode();
        }
        InputMultiplexer multiplexer = new InputMultiplexer();
        if (this.model.player.selectedAvatar.inTutorial()) {
            this.battleTutorial = new BattleTutorial(this);
            multiplexer.addProcessor(this.battleTutorial);
        }
        multiplexer.addProcessor(this.uiStage);
        multiplexer.addProcessor(this.hudStage);
        multiplexer.addProcessor(this.battlefield);
        Gdx.input.setInputProcessor(multiplexer);
        this.soundSystem.battle.play("sound/music/11 - Start loop.mp3", true);
    }

    @Override
    protected Viewport mapViewport() {
        return new ExtendViewport(1024.0f, 576.0f, 1408.0f, 576.0f, this.camera);
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case BattleData: {
                this.onBattleData();
                break;
            }
            case BattleEventRound: {
                this.onEndRound();
                break;
            }
            case BattleEventResult: {
                this.onBattleEnd();
                break;
            }
            case BattleEventReady: {
                this.onAvatarReady();
                break;
            }
        }
    }

    private void onAvatarReady() {
        BattleData battleData = this.model.battle;
        this.hud.setReady(battleData.isReadyAvatar1, battleData.isReadyAvatar2);
    }

    private void onBattleEnd() {
        this.battleIsComplete = true;
        if (this.battlefield.isAnimationFinished()) {
            this.openFinishWindow();
        }
    }

    private void openFinishWindow() {
        BattleData battleData = this.model.battle;
        if (battleData.battleResult != null) {
            if (this.observationMode) {
                this.windowManager.open(BattleEndObserverWindow.create(battleData));
            } else {
                BattleEndWindow wnd = new BattleEndWindow(this.model.battle);
                this.windowManager.open(wnd, true);
            }
            this.soundSystem.fx.stop();
            this.soundSystem.music.stop();
            this.soundSystem.battle.play("sound/music/13 - End loop.mp3", true);
            this.soundSystem.fx.play("sound/music/12 - Battle end.mp3");
        }
    }

    private void openAttackWindow() {
        BattleData battleData = this.model.battle;
        AttackWindow wnd = new AttackWindow(battleData.getOpponent(this.model.player.selectedAvatar)){

            @Override
            public void closeHandler() {
                super.closeHandler();
                BattleScreen.this.soundSystem.music.stop();
                BattleScreen.this.soundSystem.battle.stop();
                BattleScreen.this.soundSystem.alarm.stop();
                String randomMusic = Math.random() < 0.5 ? "sound/music/07 - Battle Theme 1.mp3" : "sound/music/08 - Battle Theme 2.mp3";
                BattleScreen.this.soundSystem.music.play(randomMusic, true);
            }
        };
        this.windowManager.open(wnd, true);
        this.soundSystem.fx.play("sound/music/10 - Alert.mp3", true);
    }

    private void onEndRound() {
        this.hud.hideAll();
        this.soundSystem.fx.stop();
        this.soundSystem.music.resume();
        BattleData battleData = this.model.battle;
        if (this.model.battle.avatar2.id == this.model.player.selectedAvatar.id) {
            this.setHudArtefactTypeId(battleData.artefactTypeId2);
            this.battlefield.parseAttackUnit(battleData.unitAttack2, battleData.unitAttack1, battleData.useArtefacts2, battleData.useArtefacts1);
        } else {
            this.setHudArtefactTypeId(battleData.artefactTypeId1);
            this.battlefield.parseAttackUnit(battleData.unitAttack1, battleData.unitAttack2, battleData.useArtefacts1, battleData.useArtefacts2);
        }
        this.hud.setTimeEnd(battleData.getTimeEnd());
        this.hud.setReady(battleData.isReadyAvatar1, battleData.isReadyAvatar2);
    }

    private void onBattleData() {
        AvatarData avatar1 = null;
        AvatarData avatar2 = null;
        long artefactTypeId = 0L;
        if (this.model.battle.avatar1.id == this.model.player.selectedAvatar.id) {
            avatar1 = this.model.battle.avatar1;
            avatar2 = this.model.battle.avatar2;
            artefactTypeId = this.model.battle.artefactTypeId1;
        } else if (this.model.battle.avatar2.id == this.model.player.selectedAvatar.id) {
            avatar2 = this.model.battle.avatar1;
            avatar1 = this.model.battle.avatar2;
            artefactTypeId = this.model.battle.artefactTypeId2;
        } else {
            avatar1 = this.model.battle.avatar1;
            avatar2 = this.model.battle.avatar2;
            this.showAttackWindow = false;
        }
        this.battlefield.init(avatar1, avatar2);
        this.hud.setAvatars(this.model.battle.avatar1, this.model.battle.avatar2);
        this.setHudArtefactTypeId(artefactTypeId);
        this.hud.bottomPanel.updateArtefacts();
        this.resize(Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
        this.hud.setTimeEnd(this.model.battle.getTimeEnd());
        this.hud.setReady(this.model.battle.isReadyAvatar1, this.model.battle.isReadyAvatar2);
        if (this.showAttackWindow) {
            this.openAttackWindow();
            this.showAttackWindow = false;
        }
    }

    private void setHudArtefactTypeId(long artefactTypeId) {
        this.hud.bottomPanel.setArtefactId(this.model.battle.canUseAnyArtefact() ? 0L : artefactTypeId);
    }

    private void loadZone() {
        Static.StaticZone currentZone = this.storage.zone.get(this.model.battle.zoneId);
        Static.StaticZone leftZone = this.storage.zone.getLeftZone(currentZone.getPlanetId(), currentZone.getId());
        Static.StaticZone rightZone = this.storage.zone.getRightZone(currentZone.getPlanetId(), currentZone.getId());
        this.map.load(currentZone, leftZone, rightZone, false);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.viewport.apply();
        this.battlefield.screenShaker.update(delta);
        this.camera.update();
        this.renderer.setView(this.camera);
        this.renderer.render();
        this.mapStage.act(delta);
        this.mapStage.draw();
        this.hudStage.act(delta);
        this.hudViewport.apply();
        this.hudStage.draw();
        this.uiStage.act(delta);
        this.uiViewport.apply();
        this.uiStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.hudViewport.update(width, height, true);
        this.uiViewport.update(width, height, true);
        this.hud.resize(width, height);
        this.camera.position.set((float)this.map.getWidth() / 2.0f, (float)this.map.getHeight() / 2.0f, 0.0f);
        this.shadow.setSize(width, height);
        this.battlefield.screenShaker.updateCameraPosition();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
        super.resume();
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.soundSystem.battle.stop();
        if (this.battleTutorial != null) {
            this.battleTutorial.dispose();
        }
        this.model.removeListeners(this);
        this.windowManager.removeListener(this.closeWindowListener);
        this.windowManager.closeAll();
        this.windowManager.clearListeners();
        Gdx.input.setInputProcessor(null);
    }

    @Override
    public void onEvent(int type, Boolean data) {
        switch (type) {
            case 10: {
                this.hud.bottomPanel.lockStartRoundButton(data == false);
                break;
            }
            case 13: {
                if (this.battleIsComplete) {
                    this.openFinishWindow();
                    break;
                }
                this.soundSystem.fx.play("sound/music/Battle new round.mp3");
                this.hud.bottomPanel.unlockButtons();
                this.hud.bottomPanel.lockStartRoundButton(true);
                this.hud.showAll();
                break;
            }
            case 14: {
                if (data.booleanValue()) {
                    this.hud.bottomPanel.lockArtefacts();
                    break;
                }
                this.hud.bottomPanel.updateArtefacts();
                break;
            }
            case 15: {
                this.hud.bottomPanel.updateArtefacts();
            }
        }
    }

    public Battlefield getBattlefield() {
        return this.battlefield;
    }

    public BattleHud getHud() {
        return this.hud;
    }
}

