/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.Teleports;
import com.tpwar.domain.Model;
import com.tpwar.game.screens.MainMenuScreen;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.menu.AvatarInputName;
import com.tpwar.game.windows.menu.FractionButton;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import packet.Base;
import packet.Static;
import packet.Transport;

public class CreateCharacterScreen
implements Screen,
MessageListener {
    private Model model = Model.getInstance();
    private Storage storage = Storage.getInstance();
    private WindowManager windowManager = WindowManager.getInstance();
    private TextureAtlas atlas;
    private Teleports app;
    private Stage backStage;
    private Stage stage;
    private Viewport viewport;
    private Image background;
    private FractionButton backButton;
    private FractionButton frontButton;
    private Array<FractionButton> fractionButtons = new Array(2);
    private AvatarInputName avatarInputName;
    private FillViewport uiViewport;
    private Stage uiStage;

    public CreateCharacterScreen(Teleports app) {
        this.app = app;
    }

    @Override
    public void show() {
        this.atlas = new TextureAtlas(Gdx.files.internal("menu/main_menu.atlas"));
        this.backStage = new Stage(new FillViewport(1024.0f, 576.0f));
        this.background = new Image(this.atlas.findRegion("back"));
        this.backStage.addActor(this.background);
        this.viewport = new FitViewport(1024.0f, 576.0f);
        this.stage = new Stage(this.viewport);
        this.uiViewport = new FillViewport(1024.0f, 576.0f);
        this.uiStage = new Stage(this.uiViewport);
        this.windowManager.setStage(this.uiStage);
        this.avatarInputName = new AvatarInputName(this.atlas);
        this.avatarInputName.setPosition(640.0f, 300.0f);
        this.avatarInputName.getColor().a = 0.0f;
        this.stage.addActor(this.avatarInputName);
        SelectFractionClickListener clickListener = new SelectFractionClickListener();
        Static.StaticFaction oseonFraction = this.storage.faction.getFactionByCode("osion");
        this.createAndAddFractionBtn(oseonFraction, 180.0f, 145.0f, clickListener);
        Static.StaticFaction waylandFraction = this.storage.faction.getFactionByCode("weyland");
        this.createAndAddFractionBtn(waylandFraction, 590.0f, 145.0f, clickListener);
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(new InputAdapter(){

            @Override
            public boolean keyDown(int keycode) {
                switch (keycode) {
                    case 4: 
                    case 111: {
                        CreateCharacterScreen.this.app.setScreen(new MainMenuScreen(CreateCharacterScreen.this.app));
                        return true;
                    }
                }
                return false;
            }
        });
        inputMultiplexer.addProcessor(this.uiStage);
        inputMultiplexer.addProcessor(this.stage);
        Gdx.input.setInputProcessor(inputMultiplexer);
        this.model.addListeners((MessageListener)this, Cmd.Error.getCode());
        this.model.addListeners((MessageListener)this, Cmd.AvatarDto.getCode());
    }

    private FractionButton createAndAddFractionBtn(Static.StaticFaction fraction, float x, float y, ClickListener clickListener) {
        FractionButton fractionBtn = new FractionButton(this.atlas, fraction);
        fractionBtn.setPosition(x, y);
        fractionBtn.addListener(clickListener);
        this.stage.addActor(fractionBtn);
        this.fractionButtons.add(fractionBtn);
        return fractionBtn;
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case Error: {
                Base.ErrorMsg error = Base.ErrorMsg.parseFrom(msg.getData());
                if (error.getCode() != 121) break;
                WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.create_fail.message", "window.error.create_fail.answer");
                this.windowManager.open(wnd, true);
                break;
            }
            case AvatarDto: {
                this.app.setScreen(new MainMenuScreen(this.app));
                break;
            }
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.backStage.getViewport().apply();
        this.backStage.act(delta);
        this.backStage.draw();
        this.stage.getViewport().apply();
        this.stage.act(delta);
        this.stage.draw();
        this.uiViewport.apply();
        this.uiStage.act();
        this.uiStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.backStage.getViewport().update(width, height);
        this.uiViewport.update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.atlas.dispose();
        this.model.removeListeners(this);
        this.windowManager.closeAll();
        Gdx.input.setInputProcessor(null);
        this.backStage.dispose();
        this.stage.dispose();
        this.uiStage.dispose();
    }

    private class SelectFractionClickListener
    extends ClickListener {
        boolean flag = true;

        private SelectFractionClickListener() {
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            SequenceAction moveToBack = Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(140.0f, 155.0f, 0.3f, Interpolation.swingOut), (Action)Actions.scaleTo(0.92f, 0.92f, 0.3f)), (Action)Actions.run(new Runnable(){

                @Override
                public void run() {
                    CreateCharacterScreen.this.backButton.setZIndex(1);
                }
            }));
            SequenceAction moveToFront = Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(200.0f, 145.0f, 0.3f, Interpolation.swingOut), (Action)Actions.scaleTo(1.0f, 1.0f, 0.3f)), (Action)Actions.run(new Runnable(){

                @Override
                public void run() {
                    CreateCharacterScreen.this.backButton.setZIndex(1);
                }
            }));
            FractionButton button = (FractionButton)event.getTarget();
            if (CreateCharacterScreen.this.backButton == null) {
                if (button == CreateCharacterScreen.this.fractionButtons.get(0)) {
                    this.flag = false;
                }
                CreateCharacterScreen.this.avatarInputName.addAction(Actions.alpha(1.0f, 0.4f, Interpolation.exp5In));
            }
            if (this.flag) {
                CreateCharacterScreen.this.backButton = CreateCharacterScreen.this.fractionButtons.get(0);
                CreateCharacterScreen.this.frontButton = CreateCharacterScreen.this.fractionButtons.get(1);
                CreateCharacterScreen.this.backButton.addAction(moveToBack);
                CreateCharacterScreen.this.frontButton.addAction(moveToFront);
            } else {
                CreateCharacterScreen.this.backButton = CreateCharacterScreen.this.fractionButtons.get(1);
                CreateCharacterScreen.this.frontButton = CreateCharacterScreen.this.fractionButtons.get(0);
                CreateCharacterScreen.this.backButton.addAction(moveToBack);
                CreateCharacterScreen.this.frontButton.addAction(moveToFront);
            }
            CreateCharacterScreen.this.avatarInputName.setFractionId(CreateCharacterScreen.this.frontButton.getFraction().getId());
            this.flag = !this.flag;
        }
    }
}

