/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.tpwar.Teleports;
import com.tpwar.domain.Model;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.renders.OrthogonalMapRenderer;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;

public abstract class GameScreen
implements Screen {
    protected final Teleports app;
    protected final Assets assets = Assets.getInstance();
    protected final Model model = Model.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final Commander commander = Commander.getInstance();
    protected final LocalSettings localSettings = LocalSettings.getInstance();
    protected final WindowManager windowManager = WindowManager.getInstance();
    protected final SoundSystem soundSystem = SoundSystem.getInstance();
    protected Batch batch;
    protected OrthogonalTiledMapRenderer renderer;
    protected OrthographicCamera camera;
    protected Viewport viewport;
    protected Tpmap map;
    protected Stage mapStage;
    protected Stage hudStage;
    protected Viewport hudViewport;
    protected Stage uiStage;
    protected Viewport uiViewport;

    public GameScreen(Teleports app) {
        this.app = app;
    }

    @Override
    public void show() {
        this.batch = new SpriteBatch();
        this.map = new Tpmap();
        this.renderer = new OrthogonalMapRenderer((TiledMap)this.map, this.batch);
        this.camera = new OrthographicCamera();
        this.viewport = ScaleScreen.isDesktop() ? new ScreenViewport(this.camera) : this.mapViewport();
        this.mapStage = new Stage(this.viewport);
        this.mapStage.addActor(this.map.getObjectsLayer());
        this.hudViewport = new ScreenViewport();
        this.hudStage = new Stage(this.hudViewport);
        this.uiViewport = ScaleScreen.isDesktop() ? new ScreenViewport() : new FillViewport(1024.0f, 576.0f);
        this.uiStage = new Stage(this.uiViewport);
        this.windowManager.setStage(this.uiStage);
    }

    protected Viewport mapViewport() {
        return new FillViewport(1024.0f, 576.0f, this.camera);
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
        this.map.dispose();
        this.renderer.dispose();
        Gdx.input.setInputProcessor(null);
        this.hudStage.dispose();
        this.uiStage.dispose();
        this.batch.dispose();
    }

    protected void fixBounds() {
        float gutterWidth = (float)this.viewport.getScreenX() / (float)this.viewport.getScreenWidth() * this.viewport.getWorldWidth();
        float gutterHeight = (float)this.viewport.getScreenY() / (float)this.viewport.getScreenHeight() * this.viewport.getWorldHeight();
        this.camera.position.x = this.viewport.getWorldWidth() < (float)this.map.getWidth() ? MathUtils.clamp(this.camera.position.x, this.viewport.getWorldWidth() / 2.0f + gutterWidth, (float)this.map.getWidth() - this.viewport.getWorldWidth() / 2.0f - gutterWidth) : (float)this.map.getWidth() / 2.0f - gutterWidth;
        this.camera.position.y = this.viewport.getWorldHeight() < (float)this.map.getHeight() ? MathUtils.clamp(this.camera.position.y, this.viewport.getWorldHeight() / 2.0f + gutterHeight, (float)this.map.getHeight() - this.viewport.getWorldHeight() / 2.0f - gutterHeight) : (float)this.map.getHeight() / 2.0f - gutterHeight;
    }

    public Stage getStage() {
        return this.hudStage;
    }

    public Viewport getViewport() {
        return this.viewport;
    }
}

