/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.Teleports;
import com.tpwar.domain.Credentials;
import com.tpwar.domain.Model;
import com.tpwar.game.managers.AccountManager;
import com.tpwar.game.screens.LoginScreen;
import com.tpwar.game.screens.MainMenuScreen;
import com.tpwar.game.screens.preloader.CircularLoader;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.StartingAssets;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.net.Connection;
import com.tpwar.storage.Storage;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import packet.Avatars;
import packet.Base;
import packet.Static;
import packet.Transport;

public class LoadingScreen
implements Screen,
MessageListener,
Observer {
    private static final List<Integer> LISTEN_CMDS = Arrays.asList(Cmd.LoginResp.getCode(), Cmd.AvatarList.getCode(), Cmd.StaticContent.getCode(), Cmd.Error.getCode(), Cmd.SignupResp.getCode());
    private final Teleports app;
    private final Storage storage = Storage.getInstance();
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Commander commander = Commander.getInstance();
    private float progress;
    private StartingAssets loadingAssets;
    private Stage backStage;
    private Stage frontStage;
    private boolean waitForConnecting;
    private Label loadingLabel;
    private CircularLoader loader;

    public LoadingScreen(Teleports app) {
        this.app = app;
    }

    @Override
    public void show() {
        this.backStage = new Stage(new FillViewport(1024.0f, 576.0f));
        this.frontStage = new Stage(new FitViewport(1024.0f, 576.0f));
        this.loadingAssets = new StartingAssets();
        this.loadingAssets.load("ui/window.atlas", TextureAtlas.class);
        String CENTRY_GOTHIC_BOLD_16 = "GOTHICB16.ttf";
        FreetypeFontLoader.FreeTypeFontLoaderParameter parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/GOTHICB.TTF";
        parms.fontParameters.size = 16;
        parms.fontParameters.borderColor = Color.valueOf("274a72");
        parms.fontParameters.borderWidth = 0.8f;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        this.loadingAssets.load("GOTHICB16.ttf", BitmapFont.class, parms);
        String CENTRY_GOTHIC_BOLD_14 = "GOTHICB14.ttf";
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/GOTHICB.TTF";
        parms.fontParameters.size = 12;
        parms.fontParameters.borderColor = Color.valueOf("274a72");
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        this.loadingAssets.load("GOTHICB14.ttf", BitmapFont.class, parms);
        this.loadingAssets.load();
        this.loader = new CircularLoader();
        this.loader.setRadius(14.0f);
        this.loader.setStrokeWidth(4.0f);
        this.loader.setColor(new Color(0.9f, 0.92f, 0.95f, 1.0f));
        this.loader.setIndeterminate(true);
        this.progress = 0.0f;
        this.assets.load();
        this.backStage.addActor(new Image(this.loadingAssets.getPreloader()));
        Table main = new Table();
        main.setFillParent(true);
        this.frontStage.addActor(main);
        Table loadingTable = new Table();
        Label.LabelStyle style = new Label.LabelStyle((BitmapFont)this.loadingAssets.get("GOTHICB16.ttf"), Color.WHITE);
        this.loadingLabel = new Label((CharSequence)"Loading...", style);
        this.loadingLabel.setAlignment(8);
        loadingTable.add(this.loadingLabel).width(120.0f).left().padLeft(45.0f);
        loadingTable.add(this.loader).left().row();
        main.add(loadingTable).expand().bottom().left().padBottom(14.0f).row();
        Color color = Color.WHITE.cpy();
        color.a = 0.5f;
        String info = "Version: 8.4.0 | Built: 2025-12-06 17:11";
        Label version = new Label((CharSequence)info, new Label.LabelStyle((BitmapFont)this.loadingAssets.get("GOTHICB14.ttf"), color));
        main.add(version).expandX().left().padLeft(45.0f).padBottom(10.0f);
        this.app.connection.addObserver(this);
        this.app.connection.connect("game.tpwar.ru", 8888);
        this.waitForConnecting = true;
        this.app.model.addListeners((MessageListener)this, LISTEN_CMDS);
    }

    private void showMessageConnectionError() {
        if (!this.loader.remove()) {
            return;
        }
        TextureAtlas windowAtlas = (TextureAtlas)this.loadingAssets.get("ui/window.atlas");
        BitmapFont arialBold16 = (BitmapFont)this.loadingAssets.get("arialbd_16.ttf");
        String text = "Failed to connect to the server, check your internet connection and restart the game!";
        Label.LabelStyle labelStyle = new Label.LabelStyle(arialBold16, Color.WHITE);
        Label label = new Label((CharSequence)text, labelStyle);
        label.setAlignment(1);
        label.setWrap(true);
        Table container = new Table();
        container.setFillParent(true);
        Color color = Color.WHITE.cpy();
        color.a = 0.6f;
        Table panel = new Table();
        panel.setBackground(this.assets.getNinePatchDrawable(windowAtlas, "content_background", 10, 10, 5, 5).tint(color));
        panel.add(label).width(440.0f);
        container.add(panel).expandY().size(480.0f, 110.0f).bottom().padBottom(110.0f);
        this.frontStage.addActor(container);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Connection.NotConnectedEvent) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    LoadingScreen.this.showMessageConnectionError();
                }
            });
        }
    }

    @Override
    public void render(float delta) {
        this.progress = MathUtils.lerp(this.progress, this.assets.getProgress(), 0.1f);
        this.loader.setProgress(this.progress);
        this.loadingLabel.setText("Loading " + (int)(this.progress * 100.0f) + "%");
        if (this.assets.update() && this.assets.isFinished() && this.waitForConnecting) {
            this.model.lang = (I18NBundle)this.assets.get("i18n/bundle");
            this.assets.generateSkin();
            if (this.app.connection.isConnected()) {
                AccountManager.login(this.app.context.getCredentials());
            }
            this.waitForConnecting = false;
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.backStage.getViewport().apply();
        this.backStage.act();
        this.backStage.draw();
        this.frontStage.getViewport().apply();
        this.frontStage.act();
        this.frontStage.draw();
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case StaticContent: {
                this.storage.parse(((Model)data).content);
                this.app.billing.init(this.app.context.getPurchaseManager());
                this.app.connection.send(Cmd.GetAvatarList, Avatars.GetAvatarList.newBuilder().build());
                break;
            }
            case LoginResp: 
            case SignupResp: {
                this.sendLoadStaticMessage();
                break;
            }
            case AvatarList: {
                this.app.setScreen(new MainMenuScreen(this.app));
                this.app.checkTransactions();
                break;
            }
            case Error: {
                this.handleError(Base.ErrorMsg.parseFrom(msg.getData()));
                break;
            }
        }
    }

    private void handleError(Base.ErrorMsg error) {
        switch (error.getCode()) {
            case 110: {
                Credentials credentials = this.app.context.getCredentials();
                switch (credentials.getType()) {
                    case GOOGLE: {
                        this.commander.SignupGoogle(credentials);
                        break;
                    }
                    case VKONTAKTE: {
                        this.commander.SignupVk(credentials.getUid(), credentials.getKey());
                        break;
                    }
                    case VK_ID: {
                        this.commander.SignupVkId(credentials.getUid(), credentials.getKey());
                    }
                }
                break;
            }
            case 111: {
                this.app.setScreen(new LoginScreen(this.app));
                break;
            }
        }
    }

    private void sendLoadStaticMessage() {
        Static.GetStaticContent.Builder msg = Static.GetStaticContent.newBuilder();
        this.app.connection.send(Cmd.GetStaticContent, msg.build());
    }

    @Override
    public void resize(int width, int height) {
        this.backStage.getViewport().update(width, height);
        this.frontStage.getViewport().update(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.app.connection.deleteObserver(this);
        this.app.model.removeListeners(this);
        this.backStage.dispose();
        this.frontStage.dispose();
        this.loadingAssets.dispose();
    }
}

