/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.tpwar.Teleports;
import com.tpwar.game.screens.LoadingScreen;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.StartingAssets;
import com.tpwar.platform.LoginManager;
import java.util.Observable;
import java.util.Observer;

public class LoginScreen
extends ScreenAdapter {
    private Teleports app;
    private Stage backStage;
    private Stage frontStage;
    private StartingAssets assets;

    public LoginScreen(Teleports app) {
        this.app = app;
    }

    @Override
    public void show() {
        this.backStage = new Stage(new FillViewport(1024.0f, 576.0f));
        this.frontStage = new Stage(new FitViewport(1024.0f, 576.0f));
        this.assets = new StartingAssets();
        this.assets.load("ui/window.atlas", TextureAtlas.class);
        this.assets.load("login/login.atlas", TextureAtlas.class);
        this.assets.load();
        this.backStage.addActor(new Image(this.assets.getPreloader()));
        TextureAtlas windowAtlas = (TextureAtlas)this.assets.get("ui/window.atlas");
        BitmapFont arialBold16 = (BitmapFont)this.assets.get("arialbd_16.ttf");
        TextureAtlas atlas = (TextureAtlas)this.assets.get("login/login.atlas");
        Assets assets = Assets.getInstance();
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = assets.getNinePatchDrawable(atlas, "vk_btn_up", 46, 10, 0, 0);
        btnStyle.down = assets.getNinePatchDrawable(atlas, "vk_btn_down", 46, 10, 0, 0);
        btnStyle.font = arialBold16;
        TextButton vkButton = new TextButton("VKontakte", btnStyle);
        vkButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                LoginScreen.this.app.context.getLoginManager().signIn(LoginManager.ServiceType.VK_ID);
            }
        });
        btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = assets.getNinePatchDrawable(atlas, "google_btn_up", 46, 10, 0, 0);
        btnStyle.down = assets.getNinePatchDrawable(atlas, "google_btn_down", 46, 10, 0, 0);
        btnStyle.font = arialBold16;
        btnStyle.fontColor = Color.DARK_GRAY;
        TextButton gButton = new TextButton("Google", btnStyle);
        gButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                LoginScreen.this.app.context.getLoginManager().signIn(LoginManager.ServiceType.GOOGLE);
            }
        });
        String text = this.assets.get("i18n/bundle", I18NBundle.class).get("login.accounts");
        Label.LabelStyle labelStyle = new Label.LabelStyle(arialBold16, Color.WHITE);
        Label label = new Label((CharSequence)text, labelStyle);
        label.setWrap(true);
        Table container = new Table();
        container.setFillParent(true);
        Color color = Color.WHITE.cpy();
        color.a = 0.7f;
        Table panel = new Table();
        panel.setBackground(assets.getNinePatchDrawable(windowAtlas, "content_background", 10, 10, 5, 5).tint(color));
        Table menu = new Table();
        menu.defaults().space(8.0f);
        menu.add(vkButton).growX().row();
        menu.add(gButton).growX();
        panel.add(label).width(320.0f);
        panel.add(menu).width(160.0f);
        container.add(panel).expandY().bottom().padBottom(110.0f);
        this.frontStage.addActor(container);
        this.app.context.getLoginManager().addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object o) {
                if (LoginScreen.this.app.context.getCredentials().isValid()) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            LoginScreen.this.app.setScreen(new LoadingScreen(LoginScreen.this.app));
                        }
                    });
                }
            }
        });
        Gdx.input.setInputProcessor(this.frontStage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.backStage.getViewport().apply();
        this.backStage.act(delta);
        this.backStage.draw();
        this.frontStage.getViewport().apply();
        this.frontStage.act(delta);
        this.frontStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.backStage.getViewport().update(width, height);
        this.frontStage.getViewport().update(width, height);
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.app.context.getLoginManager().deleteObservers();
        Gdx.input.setInputProcessor(null);
        this.backStage.dispose();
        this.frontStage.dispose();
        this.assets.dispose();
    }
}

