/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.Teleports;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.player.PlayerData;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.screens.CreateCharacterScreen;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.gift.ActivatedGiftWindow;
import com.tpwar.game.windows.menu.AvatarSlot;
import com.tpwar.game.windows.menu.BankBlock;
import com.tpwar.game.windows.menu.EmptySlot;
import com.tpwar.game.windows.menu.LockedSlot;
import com.tpwar.game.windows.menu.NotificationWindow;
import com.tpwar.game.windows.menu.RulesWindow;
import com.tpwar.game.windows.menu.SettingsWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.net.Connection;
import com.tpwar.sound.SoundSystem;
import packet.Avatars;
import packet.Base;
import packet.Transport;

public class MainMenuScreen
implements Screen,
MessageListener {
    private static final String TAG = MainMenuScreen.class.getSimpleName();
    private static final int MAX_AVATAR_SLOTS = 30;
    private final Teleports app;
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private Stage backStage;
    private Stage stage;
    private Stage uiStage;
    private Image background;
    private ImageButton settingsBtn;
    private DelayedRemovalArray<Actor> slots = new DelayedRemovalArray(5);
    private Long selectedAvatarId;
    private TextureAtlas menuAtlas;
    private Table slotsContainer;
    private BankBlock bankBlock;

    public MainMenuScreen(Teleports app) {
        this.app = app;
    }

    @Override
    public void show() {
        this.backStage = new Stage(new FillViewport(1024.0f, 576.0f));
        this.stage = new Stage(new FitViewport(1024.0f, 576.0f));
        this.menuAtlas = new TextureAtlas(Gdx.files.internal("menu/main_menu.atlas"));
        this.background = new Image(this.menuAtlas.findRegion("back"));
        this.backStage.addActor(this.background);
        this.uiStage = new Stage(new FillViewport(1024.0f, 576.0f));
        this.windowManager.setStage(this.uiStage);
        Image title = new Image(this.menuAtlas.findRegion("the_teleports"));
        title.setPosition((1024.0f - title.getWidth()) / 2.0f, 576.0f - title.getHeight() - 16.0f);
        this.stage.addActor(title);
        this.slotsContainer = new Table();
        this.slotsContainer.defaults().space(50.0f);
        Table table = new Table();
        table.defaults().padTop(26.0f);
        table.padLeft(60.0f).padRight(60.0f);
        table.setFillParent(true);
        table.add(new ScrollPane((Actor)this.slotsContainer)).grow();
        this.stage.addActor(table);
        Table topDecor = this.topDecor();
        topDecor.pack();
        topDecor.setPosition(512.0f - topDecor.getWidth() / 4.0f, 450.0f);
        this.stage.addActor(topDecor);
        Table bottomDecor = this.bottomDecor();
        bottomDecor.pack();
        bottomDecor.setPosition(512.0f - bottomDecor.getWidth() / 4.0f, 82.0f);
        this.stage.addActor(bottomDecor);
        this.initSlots();
        this.settingsBtn = Component.getImageButton(this.menuAtlas, "setting_btn");
        this.settingsBtn.setPosition(this.background.getWidth() - 70.0f, 20.0f);
        this.settingsBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MainMenuScreen.this.windowManager.open(new SettingsWindow(MainMenuScreen.this.menuAtlas));
            }
        });
        this.stage.addActor(this.settingsBtn);
        ImageButton notificationBtn = Component.getImageButton(this.menuAtlas, "notif_icon");
        notificationBtn.setPosition(this.background.getWidth() - 52.0f, this.background.getHeight() - 54.0f);
        notificationBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MainMenuScreen.this.windowManager.open(new NotificationWindow(MainMenuScreen.this.menuAtlas));
            }
        });
        this.stage.addActor(notificationBtn);
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor(this.uiStage);
        multiplexer.addProcessor(this.stage);
        multiplexer.addProcessor(new InputAdapter(){

            @Override
            public boolean keyDown(int keycode) {
                switch (keycode) {
                    case 4: 
                    case 111: {
                        WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.confirm.close", "window.confirm.close.message", "window.confirm.close.answer");
                        wnd.setActionlistener(new ClickListener(){

                            @Override
                            public void clicked(InputEvent event, float x, float y) {
                                Gdx.app.exit();
                            }
                        });
                        MainMenuScreen.this.windowManager.open(wnd, true);
                    }
                }
                return super.keyDown(keycode);
            }
        });
        TextButton.TextButtonStyle tbStyle = new TextButton.TextButtonStyle();
        tbStyle.font = this.assets.getFont().arialBold16;
        tbStyle.fontColor = Color.GRAY;
        TextButton logoutBtn = new TextButton(this.model.lang.get("menu.exit"), tbStyle);
        logoutBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Connection.getInstance().close();
                MainMenuScreen.this.app.context.getLoginManager().signOut();
                Gdx.app.exit();
            }
        });
        logoutBtn.setPosition(35.0f, 29.0f);
        this.stage.addActor(logoutBtn);
        TextButton rulesBtn = new TextButton(this.model.lang.get("menu.rules"), tbStyle);
        rulesBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenuScreen.this.windowManager.open(new RulesWindow(), true);
            }
        });
        rulesBtn.setPosition(864.0f, 29.0f);
        this.stage.addActor(rulesBtn);
        this.bankBlock = new BankBlock(this.menuAtlas);
        this.bankBlock.setPosition((1024.0f - this.bankBlock.getWidth()) / 2.0f, 28.0f);
        this.stage.addActor(this.bankBlock);
        Gdx.input.setInputProcessor(multiplexer);
        this.model.addListener(this, Cmd.Error.getCode());
        this.model.addListener(this, Cmd.PlayerUpdate.getCode());
        this.model.addListener(this, Cmd.AvatarSlotPurchased.getCode());
        this.model.addListener(this, Cmd.AvatarList.getCode());
        this.soundSystem.music.play("sound/music/01 - Main Theme.mp3", true);
        this.showActivatedGifts();
    }

    public void showActivatedGifts() {
        if (this.model.player.activatedGifts.notEmpty()) {
            for (PlayerGiftData gift : this.model.player.activatedGifts) {
                this.windowManager.open(new ActivatedGiftWindow(gift));
            }
            this.model.player.activatedGifts.clear();
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case Error: {
                Base.ErrorMsg error = Base.ErrorMsg.parseFrom(msg.getData());
                if (error.getCode() == 123) {
                    final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.double_auth.message", "window.error.double_auth.answer");
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            Commander.getInstance().ResetAvatarSession(MainMenuScreen.this.selectedAvatarId);
                            wnd.closeHandler();
                        }
                    });
                    this.windowManager.open(wnd, true);
                    break;
                }
                if (error.getCode() != 129) break;
                String text = "\u042d\u0442\u0430 \u043f\u043e\u0447\u0442\u0430 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0434\u0440\u0443\u0433\u0443\u044e";
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, "\u041e\u0448\u0438\u0431\u043a\u0430", text, "Ok");
                this.windowManager.open(wnd, true);
                break;
            }
            case AvatarSlotPurchased: 
            case PlayerUpdate: {
                this.updateSlots();
                this.bankBlock.update();
                this.bankBlock.setPosition((1024.0f - this.bankBlock.getWidth()) / 2.0f, 30.0f);
                break;
            }
            case AvatarList: {
                this.initSlots();
                break;
            }
        }
    }

    private void initSlots() {
        Group slot;
        int i;
        this.slotsContainer.clear();
        this.slots.clear();
        Array<AvatarData> avatars = this.app.model.player.avatars;
        avatars.sort();
        for (i = 0; i < avatars.size; ++i) {
            slot = new AvatarSlot(this.menuAtlas, avatars.get(i));
            slot.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    AvatarSlot clickedSlot = (AvatarSlot)event.getListenerActor();
                    Avatars.SelectAvatar.Builder msg = Avatars.SelectAvatar.newBuilder();
                    MainMenuScreen.this.selectedAvatarId = clickedSlot.getAvatar().id;
                    msg.setId(MainMenuScreen.this.selectedAvatarId);
                    MainMenuScreen.this.app.connection.send(Cmd.SelectAvatar, msg.build());
                    MainMenuScreen.this.soundSystem.fx.play("sound/fx/5. Teleport (move to a new planet, enter the game).mp3");
                }
            });
            this.slotsContainer.add(slot).expand();
            this.slots.add(slot);
        }
        while (i < Math.min(Math.max(this.app.model.player.availNumAvatars + 1, 5), 30)) {
            if (i < this.app.model.player.availNumAvatars) {
                slot = new EmptySlot(this.assets, this.menuAtlas);
                slot.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        MainMenuScreen.this.app.setScreen(new CreateCharacterScreen(MainMenuScreen.this.app));
                    }
                });
            } else {
                slot = this.addLockedSlot();
            }
            this.slotsContainer.add(slot).expand();
            this.slots.add(slot);
            ++i;
        }
    }

    private void updateSlots() {
        PlayerData player = this.app.model.player;
        Array<AvatarData> avatars = this.app.model.player.avatars;
        avatars.sort();
        for (int i = 0; i < this.slots.size; ++i) {
            Actor slot = (Actor)this.slots.get(i);
            if (avatars.size > i && slot instanceof EmptySlot) {
                Cell<Actor> cell = this.slotsContainer.getCell(slot);
                AvatarSlot avatarSlot = new AvatarSlot(this.menuAtlas, avatars.get(i));
                avatarSlot.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        AvatarSlot clickedSlot = (AvatarSlot)event.getListenerActor();
                        Avatars.SelectAvatar.Builder msg = Avatars.SelectAvatar.newBuilder();
                        MainMenuScreen.this.selectedAvatarId = clickedSlot.getAvatar().id;
                        msg.setId(MainMenuScreen.this.selectedAvatarId);
                        MainMenuScreen.this.app.connection.send(Cmd.SelectAvatar, msg.build());
                        Gdx.app.log(TAG, "select avatar name=" + clickedSlot.getAvatar().name);
                    }
                });
                cell.setActor(avatarSlot);
                this.slots.set(i, avatarSlot);
                continue;
            }
            if (!(slot instanceof LockedSlot)) continue;
            LockedSlot lockedSlot = (LockedSlot)slot;
            if (i < player.availNumAvatars) {
                Cell<LockedSlot> cell = this.slotsContainer.getCell(lockedSlot);
                EmptySlot emptySlot = new EmptySlot(this.assets, this.menuAtlas);
                emptySlot.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        MainMenuScreen.this.app.setScreen(new CreateCharacterScreen(MainMenuScreen.this.app));
                    }
                });
                cell.setActor(emptySlot);
                this.slots.set(i, emptySlot);
                continue;
            }
            int price = Math.min(player.availNumAvatars, 5) * 25;
            lockedSlot.updatePrice(price);
        }
        if (player.availNumAvatars >= 5 && player.availNumAvatars < 30) {
            LockedSlot slot = this.addLockedSlot();
            this.slotsContainer.add(slot).expand();
            this.slots.add(slot);
        }
    }

    private LockedSlot addLockedSlot() {
        int price = Math.min(this.app.model.player.availNumAvatars, 5) * 25;
        LockedSlot slot = new LockedSlot(this.assets, this.menuAtlas, price);
        slot.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                final PlayerData player = MainMenuScreen.this.app.model.player;
                final int price = Math.min(player.availNumAvatars, 5) * 25;
                if (player.availNumAvatars <= 30) {
                    String title = MainMenuScreen.this.model.lang.get("window.confirm.buy_avatar_slot");
                    String message = MainMenuScreen.this.model.lang.format("window.confirm.buy_avatar_slot.message", price);
                    String answer = MainMenuScreen.this.model.lang.get("window.confirm.buy_avatar_slot.answer");
                    final WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, title, message, answer);
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            wnd.closeHandler();
                            if (FinanceManager.checkCrystals(player, price)) {
                                Commander.getInstance().BuyAvatarSlot();
                            }
                        }
                    });
                    MainMenuScreen.this.windowManager.open(wnd, true);
                } else {
                    MainMenuScreen.this.app.setScreen(new CreateCharacterScreen(MainMenuScreen.this.app));
                }
                Gdx.app.debug("", "" + this.getTapCount());
            }
        });
        return slot;
    }

    private Table topDecor() {
        Table table = new Table();
        Image right = new Image(this.assets.getNinePatchDrawable(this.menuAtlas, "top_line", 10, 0, 0, 0));
        Image left = new Image(this.assets.getNinePatchDrawable(this.menuAtlas, "top_line", 10, 0, 0, 0));
        left.setScaleX(-1.0f);
        table.add(left);
        table.add(right);
        return table;
    }

    private Table bottomDecor() {
        Table table = new Table();
        Image right = new Image(this.assets.getNinePatchDrawable(this.menuAtlas, "bottom_line", 10, 0, 0, 0));
        Image left = new Image(this.assets.getNinePatchDrawable(this.menuAtlas, "bottom_line", 10, 0, 0, 0));
        left.setScaleX(-1.0f);
        table.add(left);
        table.add(right);
        return table;
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.backStage.getViewport().apply();
        this.backStage.act(delta);
        this.backStage.draw();
        this.stage.getViewport().apply();
        this.stage.act(delta);
        this.stage.draw();
        this.uiStage.getViewport().apply();
        this.uiStage.act(delta);
        this.uiStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.backStage.getViewport().update(width, height);
        this.stage.getViewport().update(width, height, true);
        this.uiStage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.menuAtlas.dispose();
        this.soundSystem.music.dispose();
        this.model.removeListeners(this);
        this.windowManager.closeAll();
        Gdx.input.setInputProcessor(null);
        this.bankBlock.dispose();
        this.backStage.dispose();
        this.stage.dispose();
        this.uiStage.dispose();
    }
}

