/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.ai.pfa.DefaultGraphPath;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Array;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.Teleports;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarQuest;
import com.tpwar.domain.avatar.AvatarQuestGoal;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.domain.avatar.BuildingStatusData;
import com.tpwar.domain.avatar.EventData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.TreasureData;
import com.tpwar.domain.avatar.TreasureStatusData;
import com.tpwar.domain.avatar.ZoneData;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.events.EventListener;
import com.tpwar.game.display.VirtualKeyboardFocus;
import com.tpwar.game.hud.MapHud;
import com.tpwar.game.hud.TargetIndicator;
import com.tpwar.game.managers.AvatarManager;
import com.tpwar.game.managers.BattleFlagManager;
import com.tpwar.game.managers.BuildingManager;
import com.tpwar.game.managers.ClanManager;
import com.tpwar.game.managers.ErrorManager;
import com.tpwar.game.managers.PunishmentManager;
import com.tpwar.game.maps.ActionMenu;
import com.tpwar.game.maps.StepPoint;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.maps.entity.Avatar;
import com.tpwar.game.maps.entity.BaseAvatar;
import com.tpwar.game.maps.entity.OtherAvatar;
import com.tpwar.game.maps.entity.Skin;
import com.tpwar.game.maps.entity.TpmapObject;
import com.tpwar.game.maps.entity.TreasureMark;
import com.tpwar.game.maps.pathfinding.TiledGraph;
import com.tpwar.game.maps.pathfinding.TiledNode;
import com.tpwar.game.maps.pathfinding.TiledPathFinder;
import com.tpwar.game.screens.GameScreen;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.LevelUpWindow;
import com.tpwar.game.windows.daily.DailyBonusWindow;
import com.tpwar.game.windows.gift.GiftWindow;
import com.tpwar.game.windows.quest.QuestWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.DataConverter;
import com.tpwar.storage.planet.PlanetData;
import com.tpwar.storage.unit.UnitTypeData;
import com.tpwar.tutorial.ArmyTutorial;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import packet.Avatars;
import packet.Base;
import packet.Building;
import packet.Event;
import packet.Fraction;
import packet.Gifts;
import packet.Static;
import packet.Transport;
import packet.Treasure;
import packet.Zone;

public class MapScreen
extends GameScreen
implements MessageListener {
    private static final String TAG = MapScreen.class.getSimpleName();
    private static boolean needScrollUp = false;
    private AvatarManager avatarManager;
    private BuildingManager buildingManager;
    private BattleFlagManager battleFlagManager;
    private ErrorManager errorManager;
    private ClanManager clanManager;
    private Avatar avatar;
    private TiledPathFinder pathFinder;
    private ActionMenu actionMenu;
    private StepPoint stepPoint;
    private TreasureMark treasure;
    private final Vector3 point = new Vector3();
    private Image shadow;
    private MapHud hud;
    private VirtualKeyboardFocus windowsKeyboardFocus;
    private ArmyTutorial armyTutorial;
    private InputMultiplexer multiplexer;
    private TargetIndicator targetIndicator;

    public MapScreen(Teleports app) {
        super(app);
    }

    @Override
    public void show() {
        super.show();
        this.avatarManager = new AvatarManager(this.map);
        this.buildingManager = new BuildingManager(this.map);
        this.battleFlagManager = new BattleFlagManager(this.map);
        this.clanManager = new ClanManager();
        this.errorManager = new ErrorManager();
        BaseAvatar.showLevelIcon = this.localSettings.levelIcons();
        AvatarData avatarData = this.model.player.selectedAvatar;
        Skin skin = this.avatarManager.getAvatarSkin(avatarData);
        this.avatar = new Avatar(avatarData, this.map, skin);
        this.pathFinder = new TiledPathFinder(this.map);
        this.stepPoint = StepPoint.create();
        this.treasure = new TreasureMark();
        this.actionMenu = new ActionMenu(new ClickListenerMoveAvatar());
        this.model.addListener(this, Cmd.ZoneData.getCode());
        this.model.addListener(this, Cmd.ZoneEventAvatarMove.getCode());
        this.model.addListener(this, Cmd.ZoneEventAvatar.getCode());
        this.model.addListener(this, Cmd.ZoneEventAvatarRemove.getCode());
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
        this.model.addListener(this, Cmd.ZoneEventBattle.getCode());
        this.model.addListener(this, Cmd.ZoneEventBattleRemove.getCode());
        this.model.addListener(this, Cmd.ChatMessage.getCode());
        this.model.addListener(this, Cmd.ChatJoined.getCode());
        this.model.addListener(this, Cmd.UpdateUnits.getCode());
        this.model.addListener(this, Cmd.ChatLeft.getCode());
        this.model.addListener(this, Cmd.TreasureStatus.getCode());
        this.model.addListener(this, Cmd.TreasureInfo.getCode());
        this.model.addListener(this, Cmd.TreasureReward.getCode());
        this.model.addListener(this, Cmd.BuildingStatus.getCode());
        this.model.addListener(this, Cmd.MineReward.getCode());
        this.model.addListener(this, Cmd.WorldStatus.getCode());
        this.model.addListener(this, Cmd.EventMessage.getCode());
        this.model.addListener(this, Cmd.AvatarTutorialData.getCode());
        this.model.addListener(this, Cmd.FractionReward.getCode());
        this.model.addListener(this, Cmd.DailyBonusData.getCode());
        this.model.addListener(this, Cmd.Error.getCode());
        this.model.addListener(this, Cmd.GiftReceived.getCode());
        this.model.addListener(this, Cmd.AvatarLevelUp.getCode());
        this.model.addListener(this, Cmd.TimeWarpList.getCode());
        this.model.addListener(this, Cmd.QuestUpdate.getCode());
        this.model.addListener(this, Cmd.Shield.getCode());
        this.model.addListener(this, Cmd.ShieldPurchased.getCode());
        this.model.addListener(this, Cmd.ClanEventInvite.getCode());
        this.model.addListener(this, Cmd.ClanEventApplication.getCode());
        this.model.addListener(this, Cmd.PlayerUpdate.getCode());
        TextureAtlas textureAtlas = (TextureAtlas)this.assets.get("ui/hud.atlas");
        NinePatchDrawable shadowDrawable = Component.getNinePatchDrawable(textureAtlas, "shadow", 50, 50, 50, 50);
        this.shadow = new Image(shadowDrawable);
        this.shadow.setTouchable(Touchable.disabled);
        this.hudStage.addActor(this.shadow);
        this.windowManager.closeAll();
        this.windowManager.addListener(1, new EventListenerImplementation());
        if (this.model.player.punishment != null && this.model.player.punishment.getAvatarId() == avatarData.id) {
            this.windowManager.open(PunishmentManager.createWindow(this.model.player.punishment));
        }
        this.model.player.punishment = null;
        avatarData.checkTimeUnits();
        this.hud = new MapHud();
        this.hudStage.addActor(this.hud);
        this.targetIndicator = new TargetIndicator(this.hudStage, this.viewport.getCamera(), this.avatar);
        this.hudStage.addActor(this.targetIndicator);
        this.windowsKeyboardFocus = new VirtualKeyboardFocus(this.uiStage);
        this.app.context.getView().addListener(this.hud);
        this.app.context.getView().addListener(this.windowsKeyboardFocus);
        LocalSettings settings = LocalSettings.getInstance();
        if (avatarData.needOpenChat && settings.chatAutoOpen()) {
            this.commander.ChatActionJoin(this.storage.chat.getGeneral().getId());
        }
        if (avatarData.hasChat()) {
            this.eventChatJoin();
        }
        this.eventAvatarUpdate(avatarData);
        this.eventUnitsUpdate();
        this.multiplexer = new InputMultiplexer();
        this.multiplexer.addProcessor(this.uiStage);
        this.multiplexer.addProcessor(this.mapStage);
        this.multiplexer.addProcessor(this.hudStage);
        this.multiplexer.addProcessor(new InputAdapterExtension());
        Gdx.input.setInputProcessor(this.multiplexer);
        this.eventTutorial();
        this.eventQuestUpdate();
        this.clanManager.eventInvitationsClan();
        this.clanManager.eventApplicationsClan();
        this.eventFractionReward();
        this.eventAvatarTaskList();
        this.eventLevelUp();
        if (!avatarData.isGateActive() && avatarData.shownGateBlockTime != avatarData.gateBlockTime) {
            avatarData.shownGateBlockTime = avatarData.gateBlockTime;
            String text = "\u0412\u044b \u043e\u0434\u0435\u0440\u0436\u0430\u043b\u0438 \u0442\u0440\u0438 \u043f\u043e\u0431\u0435\u0434\u044b \u043d\u0430 \u0432\u0440\u0430\u0442\u0430\u0445, \u0432\u0440\u0430\u0442\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0437\u0430\u0445\u0432\u0430\u0442\u0430, \u0430\u0440\u043c\u0438\u044f \u043d\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043e: " + TimeUtils.shortWithoutYear(avatarData.gateBlockTime + TimeUnit.HOURS.toMillis(1L));
            this.windowManager.open(new WarningWindow(WarningWindow.Type.WARNING, "\u0412\u0440\u0430\u0442\u0430", text, this.model.lang.get("window.confirm.ok")), true);
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case ZoneData: {
                this.eventJoinZone(this.model.zone);
                break;
            }
            case ZoneEventAvatarMove: {
                this.eventMove(Zone.ZoneEventAvatarMove.parseFrom(msg.getData()));
                break;
            }
            case ZoneEventAvatar: {
                this.eventAvatar(Avatars.AvatarDto.parseFrom(msg.getData()));
                break;
            }
            case ZoneEventAvatarRemove: {
                this.eventAvatarRemove(Zone.ZoneEventAvatarRemove.parseFrom(msg.getData()));
                break;
            }
            case AvatarUpdate: 
            case PlayerUpdate: {
                this.eventAvatarUpdate(this.model.player.selectedAvatar);
                break;
            }
            case ZoneEventBattle: {
                this.eventBattle(Zone.BattleMarkDto.parseFrom(msg.getData()));
                break;
            }
            case ZoneEventBattleRemove: {
                this.eventBattleRemove(Zone.ZoneEventBattleRemove.parseFrom(msg.getData()));
                break;
            }
            case ChatMessage: {
                this.eventChatMessage();
                break;
            }
            case ChatJoined: {
                this.eventChatJoin();
                break;
            }
            case ChatLeft: {
                this.eventChatLeft();
                break;
            }
            case UpdateUnits: {
                this.eventUnitsUpdate();
                break;
            }
            case TreasureReward: {
                this.eventTreasureReward(Treasure.TreasureRewardDto.parseFrom(msg.getData()));
                break;
            }
            case TreasureInfo: {
                this.eventTreasure(this.model.player.selectedAvatar.treasureData);
                break;
            }
            case TreasureStatus: {
                this.eventTreasureStatus();
                break;
            }
            case BuildingStatus: {
                this.eventBuildingStatus();
                break;
            }
            case MineReward: {
                this.eventMineReward(Building.MineRewardDto.parseFrom(msg.getData()));
                break;
            }
            case WorldStatus: {
                this.eventWorldStatus();
                break;
            }
            case EventMessage: {
                this.eventMessage(Event.EventMessageDto.parseFrom(msg.getData()));
                break;
            }
            case AvatarTutorialData: {
                this.eventTutorial();
                break;
            }
            case FractionReward: {
                this.eventFractionReward();
                break;
            }
            case DailyBonusData: {
                this.eventDailyBonus(Avatars.DailyBonusData.parseFrom(msg.getData()));
                break;
            }
            case GiftReceived: {
                this.eventGiftReceived(Gifts.PlayerGiftDto.parseFrom(msg.getData()));
                break;
            }
            case AvatarLevelUp: {
                this.eventLevelUp();
                break;
            }
            case TimeWarpList: {
                this.eventTimeWarpList();
                break;
            }
            case QuestUpdate: {
                this.eventQuestUpdate();
                break;
            }
            case ShieldPurchased: {
                this.eventShieldPurchased();
                break;
            }
            case ClanEventInvite: {
                this.clanManager.eventInvitationsClan();
                break;
            }
            case ClanEventApplication: {
                this.clanManager.eventApplicationsClan();
                break;
            }
            case AvatarTaskList: {
                this.eventAvatarTaskList();
                break;
            }
            case Error: {
                this.errorManager.eventError(Base.ErrorMsg.parseFrom(msg.getData()));
                break;
            }
        }
    }

    private void eventAvatarTaskList() {
        AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.needShowGuildTask) {
            WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "tutorial.guld", "tutorial.guld.devastators.avail", "window.confirm.ok");
            this.windowManager.open(wnd, true);
            avatar.needShowGuildTask = false;
        }
    }

    private void eventShieldPurchased() {
        Static.StaticShieldType shieldType = this.storage.shieldType.get(this.model.player.selectedAvatar.shieldData.typeId);
        String title = this.model.lang.get("tutorial.shield");
        String message = this.model.lang.format("tutorial.shield.message", shieldType.getTimeAction());
        String answer = this.model.lang.get("window.confirm.ok");
        WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, title, message, answer);
        this.windowManager.open(wnd);
    }

    private void eventQuestUpdate() {
        AvatarQuest avatarQuest;
        AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.inTutorial()) {
            return;
        }
        AvatarData avatarData = this.model.player.selectedAvatar;
        AvatarQuest avatarQuest2 = avatarQuest = avatarData.quests.notEmpty() ? avatarData.quests.first() : null;
        if (avatarQuest != null && (avatarQuest.goalUpdated || avatarQuest.completed && avatarQuest.reward)) {
            this.windowManager.open(new QuestWindow(avatarData.quests.first()));
        }
        this.updateQuestGoals();
    }

    private void eventTimeWarpList() {
        this.avatar.updateTimeWarp();
        AvatarData avatarData = this.model.player.selectedAvatar;
        TimeWarpData activeTimeWarp = avatarData.getActiveTimeWarp();
        if (activeTimeWarp != null) {
            Static.StaticTimeWarpType timeWarpType = avatarData.getActiveTimeWarp().getType();
            this.soundSystem.fx.play(timeWarpType.getSacle() < 0 ? "sound/fx/26. Buy_time_slower.mp3" : "sound/fx/25. Buy_time_booster.mp3");
        }
    }

    private void eventLevelUp() {
        AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.levelUpReward != null) {
            this.windowManager.open(new LevelUpWindow(avatar.levelUpReward));
            avatar.levelUpReward = null;
        }
    }

    private void eventGiftReceived(Gifts.PlayerGiftDto giftDto) {
        PlayerGiftData gift = DataConverter.fromPlayerGiftDto(giftDto);
        this.windowManager.open(new GiftWindow(gift, true));
    }

    private void eventDailyBonus(Avatars.DailyBonusData dailyBonus) {
        this.windowManager.open(new DailyBonusWindow(dailyBonus), true);
    }

    private void eventFractionReward() {
        AvatarData avatar = this.model.player.selectedAvatar;
        Array<Fraction.FractionRewardDto> rewards = avatar.fractionRewards;
        for (Fraction.FractionRewardDto reward : rewards) {
            String message;
            this.soundSystem.fx.play("sound/fx/23. Successfull_mine, dig, pryanik.mp3");
            String title = this.model.lang.get("window.fraction");
            if (reward.hasWinner()) {
                String color = this.storage.faction.getColor(reward.getWinner().getFractionId());
                message = this.model.lang.format("window.fraction.reward1", StringUtils.mark(reward.getWinner().getName(), color), reward.getEnergy(), reward.getExperience());
            } else {
                message = this.model.lang.format("window.fraction.reward2", reward.getEnergy(), reward.getExperience());
            }
            String answer = this.model.lang.get("window.fraction.answer");
            WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, title, message, answer);
            this.windowManager.open(wnd);
        }
        rewards.clear();
    }

    private void eventTutorial() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.inTutorial()) {
            this.armyTutorial = new ArmyTutorial(this);
            this.multiplexer.addProcessor(0, this.armyTutorial);
        } else if (avatarData.needShowFirstShield && avatarData.firstShieldIsActive()) {
            avatarData.needShowFirstShield = false;
            Calendar createdDate = Calendar.getInstance();
            createdDate.setTimeInMillis(avatarData.created);
            createdDate.add(5, 10);
            String message = this.model.lang.format("tutorial.first_shield.message", TimeUtils.convertTime(createdDate.getTimeInMillis()));
            WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, this.model.lang.get("tutorial.first_shield"), message, this.model.lang.get("window.confirm.ok"));
            this.windowManager.open(wnd, true);
        }
    }

    private void eventMessage(Event.EventMessageDto eventMessageDto) {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.hasChat()) {
            EventData eventData = DataConverter.fromEventMessageDto(eventMessageDto);
            if ("mine".equals(eventData.code) || "gate".equals(eventData.code)) {
                Static.StaticBuilding building = this.storage.building.get(eventData.value);
                Static.StaticZone zone = this.storage.zone.get(building.getZoneId());
                PlanetData planet = this.storage.planet.get(zone.getPlanetId());
                if (avatarData.level < planet.minLevel) {
                    return;
                }
            }
            avatarData.chat.addEvent(eventData);
        }
        this.hud.eventMessage();
    }

    private void eventWorldStatus() {
        Static.StaticZone zone = this.storage.zone.get(this.model.zone.zoneId);
        PlanetData planet = this.storage.planet.get(zone.getPlanetId());
        if (this.storage.planet.isHomePlanet(planet)) {
            if (this.model.player.selectedAvatar.worldStatus.fractionIsOccupied(planet.factionId)) {
                this.buildingManager.updateBuildingStatus(1);
            } else {
                this.buildingManager.updateBuildingStatus(2);
            }
        }
    }

    private void eventMineReward(Building.MineRewardDto mineRewardDto) {
        this.soundSystem.fx.play("sound/fx/23. Successfull_mine, dig, pryanik.mp3");
        String title = this.model.lang.get("window.confirm.mine_reward");
        String message = this.model.lang.get("window.confirm.mine_reward.message") + mineRewardDto.getEnergy();
        String answer = this.model.lang.get("window.confirm.mine_reward.answer");
        WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, title, message, answer);
        this.windowManager.open(wnd, true);
        this.updateTreasure();
    }

    private void eventTreasureStatus() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        TreasureStatusData status = avatarData.treasureStatus;
        if (avatarData.hasTreasure() && status != null) {
            this.hud.setTimer(status.timeEnd, status.timeout);
        }
    }

    private void eventBuildingStatus() {
        BuildingStatusData buildingStatus = this.model.player.selectedAvatar.buildingStatus;
        if (buildingStatus != null) {
            this.hud.setTimer(buildingStatus.timeEnd, buildingStatus.timeout);
        }
    }

    private void eventTreasure(TreasureData treasureData) {
        this.updateTreasure();
    }

    private void eventTreasureReward(Treasure.TreasureRewardDto treasureRewardDto) {
        this.soundSystem.fx.play("sound/fx/23. Successfull_mine, dig, pryanik.mp3");
        String title = this.model.lang.get("window.confirm.dig_reward");
        Object message = this.model.lang.get("window.confirm.dig_reward.message");
        String answer = this.model.lang.get("window.confirm.dig_reward.answer");
        if (treasureRewardDto.getEnergy() > 0) {
            message = (String)message + treasureRewardDto.getEnergy() + this.model.lang.get("window.confirm.dig_reward.energy");
        }
        if (treasureRewardDto.getExperience() > 0) {
            message = (String)message + treasureRewardDto.getExperience() + this.model.lang.get("window.confirm.dig_reward.exp");
        }
        if (treasureRewardDto.getUpgradePoints() > 0) {
            message = (String)message + treasureRewardDto.getUpgradePoints() + this.model.lang.get("window.confirm.dig_reward.points");
        }
        WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, title, (String)message, answer);
        this.windowManager.open(wnd, true);
        this.updateTreasure();
    }

    private void eventChatLeft() {
        this.hud.leftChat();
    }

    private void eventUnitsUpdate() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.hasNewUnits() && !this.model.player.selectedAvatar.inTutorial()) {
            int numUnits = avatarData.getNumUnits();
            String title = this.model.lang.get("window.barrack");
            Object message = this.model.lang.get("window.barrack.manned.message1");
            String answer = this.model.lang.get("window.barrack.manned.answer");
            if (numUnits < 3) {
                message = this.model.lang.get("window.barrack.manned.message2") + 33 * numUnits + "%";
            }
            this.soundSystem.fx.play("sound/fx/6. Mail_Incoming.mp3");
            WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, title, (String)message, answer);
            this.windowManager.open(wnd, true);
        }
        this.hud.unitsPanel.setNumUnit(avatarData.getNumCreatedWithHealthUnits());
    }

    private void eventChatMessage() {
        this.hud.chatMessage();
    }

    private void eventChatJoin() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (avatarData.needOpenChat) {
            avatarData.needOpenChat = false;
            EventData welcomeEvent = new EventData();
            welcomeEvent.code = "welcome";
            avatarData.chat.addEvent(welcomeEvent);
        }
        this.hud.chatPanel.setChatData(this.model.player.selectedAvatar.chat);
        this.hud.joinChat();
    }

    private void eventBattle(Zone.BattleMarkDto battle) {
        this.battleFlagManager.create(this.model.zone.getBattleMarkData(battle.getId()));
    }

    private void eventBattleRemove(Zone.ZoneEventBattleRemove data) {
        this.battleFlagManager.remove(data.getBattleId());
    }

    private void eventAvatarUpdate(AvatarData avatarData) {
        this.avatar.updatePosition(avatarData.position);
        this.avatar.updateData();
        this.hud.profile.setExp(avatarData.getProgressLevel());
        this.hud.profile.setLevel(avatarData.level);
        this.hud.profile.setAvatarName(avatarData.name);
        this.hud.energyPanel.setEnergy(avatarData.energy);
        this.hud.crystalPanel.setCrystals(this.model.player.crystals);
    }

    private void eventAvatarRemove(Zone.ZoneEventAvatarRemove data) {
        for (Long id : data.getAvatarIdList()) {
            this.avatarManager.removeAvatar(id);
            this.targetIndicator.removeTarget(id);
        }
    }

    private void eventAvatar(Avatars.AvatarDto avatarData) {
        this.avatarManager.create(DataConverter.fromAvatarDto(avatarData), this.model.player.selectedAvatar.id);
    }

    private void eventMove(Zone.ZoneEventAvatarMove data) {
        this.avatarManager.move(data.getAvatarId(), data.getPosition());
    }

    private void eventJoinZone(ZoneData zone) {
        Gdx.app.log(TAG, "join on zone " + zone.zoneId);
        this.avatarManager.removeAllAvatars();
        this.buildingManager.removeAll();
        this.battleFlagManager.removeAll();
        this.targetIndicator.clear();
        this.map.clearObjects();
        Static.StaticZone currentZone = this.storage.zone.get(zone.zoneId);
        Static.StaticZone leftZone = this.storage.zone.getLeftZone(currentZone.getPlanetId(), currentZone.getId());
        Static.StaticZone rightZone = this.storage.zone.getRightZone(currentZone.getPlanetId(), currentZone.getId());
        this.map.load(currentZone, leftZone, rightZone);
        this.map.addEntity(this.avatar);
        this.map.addEntity(this.stepPoint);
        this.updateTreasure();
        this.buildingManager.create(zone.buildings);
        this.avatarManager.create(zone.avatars, this.model.player.selectedAvatar.id);
        this.battleFlagManager.create(zone.battles);
        this.pathFinder.updateMoveMap();
        this.map.sortObjects();
        this.avatar.unlockMove();
        this.eventBuildingStatus();
        this.eventTreasureStatus();
        this.eventWorldStatus();
        this.updateQuestGoals();
        this.hud.showLocation(currentZone.getPlanetId(), currentZone.getId());
        this.soundSystem.music.play(this.storage.planet.get(currentZone.getPlanetId()).getSoundName(), true);
        if (this.model.player.selectedAvatar.inTutorial() && this.armyTutorial != null) {
            this.armyTutorial.nextStep();
        }
    }

    private void updateQuestGoals() {
        AvatarQuest avatarQuest;
        AvatarData avatarData = this.model.player.selectedAvatar;
        AvatarQuest avatarQuest2 = avatarQuest = avatarData.quests.notEmpty() ? avatarData.quests.first() : null;
        if (avatarQuest != null && !avatarQuest.completed && avatarQuest.isActive()) {
            for (AvatarQuestGoal qg : avatarQuest.goals) {
                OtherAvatar otherAvatar = null;
                if (qg.getQuestGoalType().getCode().equals("treasure_map")) {
                    otherAvatar = this.avatarManager.updateQuestGoal(qg);
                } else if (qg.getQuestGoalType().getCode().equals("kill_avatar") || qg.getQuestGoalType().getCode().equals("defence") || qg.getQuestGoalType().getCode().equals("invide")) {
                    otherAvatar = this.avatarManager.getAvatarMap().get(qg.point);
                }
                if (otherAvatar == null) continue;
                Vector2 target = new Vector2(otherAvatar.getX(), otherAvatar.getY() + 40.0f);
                this.targetIndicator.addTarget(otherAvatar.avatar.id, target, otherAvatar.avatar.getFullName());
            }
        }
    }

    private void updateTreasure() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        TreasureData treasureData = avatarData.treasureData;
        if (treasureData != null && treasureData.zoneId == avatarData.zoneId && treasureData.planetId == avatarData.planetId) {
            GridPoint2 pos = Tpmap.getPosition(treasureData.position);
            this.treasure.setPosition(pos.x * 64, pos.y * 64);
            this.treasure.setData(treasureData);
            this.map.addEntity(this.treasure);
            TpmapObject bottomObject = this.map.getMapObject(treasureData.position + 20);
            if (bottomObject != null) {
                bottomObject.getColor().a = 0.5f;
            }
        } else if (this.treasure.getData() != null) {
            this.map.removeEntity(this.treasure);
            TpmapObject bottomObject = this.map.getMapObject(this.treasure.getData().position + 20);
            if (bottomObject != null) {
                bottomObject.getColor().a = 1.0f;
            }
            this.treasure.setData(null);
        }
    }

    public void removeTutorial() {
        if (this.armyTutorial != null) {
            this.multiplexer.removeProcessor(this.armyTutorial);
            this.armyTutorial.dispose();
            this.armyTutorial = null;
            UnitTypeData unit = this.storage.unitType.getUnitTypeByCode("hamer");
            String text = this.model.lang.format("tutorial.tech.message", unit.name);
            WarningWindow window = new WarningWindow(WarningWindow.Type.INFO, this.model.lang.get("tutorial.tech"), text, this.model.lang.get("window.confirm.ok"));
            this.windowManager.open(window);
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.position.set(this.avatar.getX(), this.avatar.getY(), 0.0f);
        this.fixBounds();
        this.camera.update();
        this.renderer.setView(this.camera);
        this.viewport.apply();
        this.renderer.render();
        this.mapStage.act(delta);
        this.mapStage.draw();
        this.hudStage.act(delta);
        this.hudViewport.apply();
        this.hudStage.draw();
        this.uiStage.act(delta);
        this.uiViewport.apply();
        this.uiStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.hudViewport.update(width, height, true);
        this.hud.resize(width, height);
        this.uiViewport.update(width, height, true);
        this.shadow.setSize(width, height);
        if (needScrollUp && !this.hud.isButtonsHide()) {
            this.hud.touchArrowMenu();
        }
        this.targetIndicator.resize();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
        super.resume();
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.soundSystem.music.stop();
        needScrollUp = this.hud.isButtonsHide();
        this.app.context.getView().removeListener(this.hud);
        this.app.context.getView().removeListener(this.windowsKeyboardFocus);
        this.model.removeListeners(this);
        this.windowManager.clearListeners(1);
        this.windowManager.closeAll();
        this.targetIndicator.clear();
        this.avatarManager.dispose();
        this.battleFlagManager.dispose();
        this.removeTutorial();
        this.hud.dispose();
        super.dispose();
    }

    public BuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    public Tpmap getMap() {
        return this.map;
    }

    private final class ClickListenerMoveAvatar
    extends ClickListener {
        private ClickListenerMoveAvatar() {
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            TiledGraph graph = MapScreen.this.pathFinder.getGraph();
            TiledNode start = graph.getNode(MapScreen.this.avatar.position.x, MapScreen.this.avatar.position.y);
            DefaultGraphPath<TiledNode> path = MapScreen.this.pathFinder.find(start, MapScreen.this.actionMenu.getEnd());
            MapScreen.this.stepPoint.setPosition(MapScreen.this.actionMenu.getEnd().x * 64, MapScreen.this.actionMenu.getEnd().y * 64 + 64);
            if (path.getCount() > 0 && start != MapScreen.this.actionMenu.getEnd()) {
                MapScreen.this.avatar.stopMove();
            }
            for (TiledNode node : path) {
                MapScreen.this.avatar.addPath(node);
            }
            MapScreen.this.actionMenu.remove();
        }
    }

    private final class EventListenerImplementation
    implements EventListener<GameWindow> {
        private EventListenerImplementation() {
        }

        @Override
        public void onEvent(int t, GameWindow d) {
            MapScreen.this.avatar.stopMove();
        }
    }

    private final class InputAdapterExtension
    extends InputAdapter {
        private InputAdapterExtension() {
        }

        @Override
        public boolean keyDown(int keycode) {
            switch (keycode) {
                case 4: 
                case 111: {
                    if (MapScreen.this.model.player.selectedAvatar.inTutorial()) {
                        return false;
                    }
                    final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.confirm.exit", "window.confirm.exit.message", "window.confirm.exit.answer");
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            MapScreen.this.commander.AvatarCloseSession(MapScreen.this.model.player.selectedAvatar.id);
                            wnd.closeHandler();
                        }
                    });
                    MapScreen.this.windowManager.open(wnd, true);
                }
            }
            return super.keyDown(keycode);
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            DefaultGraphPath<TiledNode> path;
            boolean hasTreasure;
            MapScreen.this.hud.unfocusChat();
            if (MapScreen.this.windowManager.hasOpenedWindow()) {
                return false;
            }
            MapScreen.this.actionMenu.remove();
            final AvatarData avatarData = MapScreen.this.model.player.selectedAvatar;
            if (avatarData.treasureDig()) {
                final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.confirm.dig", "window.confirm.dig.message", "window.confirm.dig.answer");
                wnd.setActionlistener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        MapScreen.this.soundSystem.fx.play("sound/fx/21. Leave portal, mine, digg.mp3");
                        MapScreen.this.commander.TreasureActionStop(avatarData.treasureId);
                        wnd.closeHandler();
                    }
                });
                MapScreen.this.windowManager.open(wnd, true);
                return false;
            }
            MapScreen.this.viewport.unproject(MapScreen.this.point.set(screenX, screenY, 0.0f));
            TiledGraph graph = MapScreen.this.pathFinder.getGraph();
            TiledNode start = graph.getNode(MapScreen.this.avatar.position.x, MapScreen.this.avatar.position.y);
            TiledNode end = graph.getNode((int)MapScreen.this.point.x / 64, (int)MapScreen.this.point.y / 64);
            if (end == null) {
                return false;
            }
            if (MapScreen.this.avatar.getBuilding() != null) {
                MapScreen.this.avatar.getBuilding().unselect();
                MapScreen.this.avatar.setBuilding(null);
            }
            Building building = MapScreen.this.buildingManager.getBuilding(end);
            Array<AvatarData> avatars = MapScreen.this.avatarManager.getAvatarsByPosition(end.position);
            Array<BattleMarkData> battles = MapScreen.this.battleFlagManager.getFlags(end.position);
            boolean bl = hasTreasure = MapScreen.this.treasure.getPosition() == end.position;
            if ((avatars.size > 0 || battles.size > 0 || hasTreasure) && !end.hasZone()) {
                MapScreen.this.actionMenu.show(start, end, avatars, battles, MapScreen.this.treasure.getData());
                MapScreen.this.mapStage.addActor(MapScreen.this.actionMenu);
                return false;
            }
            if (building != null) {
                end = building.findNearestNode(start);
                building.select();
            } else if (end.walkable || end.hasZone()) {
                MapScreen.this.stepPoint.show(end.x * 64, end.y * 64 + 64);
                MapScreen.this.stepPoint.toBack();
            }
            TiledNode changeZoneNode = null;
            if (MapScreen.this.map.canChangeZone()) {
                if (end.leftZoneId > 0L) {
                    changeZoneNode = end;
                    end = graph.getNode(1, end.y + 1);
                } else if (end.rightZoneId > 0L) {
                    changeZoneNode = end;
                    end = graph.getNode(20, end.y + 1);
                }
            }
            if ((path = MapScreen.this.pathFinder.find(start, end)).getCount() > 0 && start.position != end.position) {
                MapScreen.this.avatar.stopMove();
                MapScreen.this.avatar.setBuilding(building);
            } else if (building != null) {
                building.unselect();
                building.action();
            }
            if (changeZoneNode != null) {
                if (path.nodes.notEmpty()) {
                    TiledNode lastNode = (TiledNode)path.nodes.peek();
                    if (Math.abs(lastNode.x - changeZoneNode.x) == 1) {
                        path.add(changeZoneNode);
                    }
                } else if (Math.abs(MapScreen.this.avatar.position.x - changeZoneNode.x) == 1) {
                    path.add(changeZoneNode);
                }
            }
            for (TiledNode node : path) {
                MapScreen.this.avatar.addPath(node);
            }
            return true;
        }
    }
}

