/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.input.GestureDetector;
import com.tpwar.Teleports;
import com.tpwar.game.screens.GameScreen;
import com.tpwar.game.screens.camera.CameraController;
import packet.Static;

public class MapTestScreen
extends GameScreen
implements InputProcessor {
    public MapTestScreen(Teleports app) {
        super(app);
    }

    @Override
    public void show() {
        super.show();
        this.updateZone();
        Gdx.input.setInputProcessor(new GestureDetector(new CameraController(this.mapStage)));
    }

    private void updateZone() {
        Static.StaticZone currentZone = Static.StaticZone.newBuilder().setId(1L).setMapFileName("oseon_middle_gate_1").setPlanetId(1L).setPosition(1).build();
        Static.StaticZone rightZone = Static.StaticZone.newBuilder().setId(2L).setMapFileName("oseon_middle_gate_2").setPlanetId(1L).setPosition(2).build();
        Static.StaticZone leftZone = Static.StaticZone.newBuilder().setId(4L).setMapFileName("oseon_middle_gate_4").setPlanetId(1L).setPosition(4).build();
        this.map.load(currentZone, leftZone, rightZone);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.fixBounds();
        this.camera.update();
        this.renderer.setView(this.camera);
        this.viewport.apply();
        this.renderer.render(new int[]{0, 1});
        this.mapStage.act(delta);
        this.mapStage.draw();
        this.hudStage.act(delta);
        this.hudViewport.apply();
        this.hudStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.hudViewport.update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void hide() {
    }

    @Override
    public boolean keyDown(int keycode) {
        int step = 128;
        switch (keycode) {
            case 19: {
                this.camera.position.y += (float)step;
                break;
            }
            case 20: {
                this.camera.position.y -= (float)step;
                break;
            }
            case 21: {
                this.camera.position.x -= (float)step;
                break;
            }
            case 22: {
                this.camera.position.x += (float)step;
                break;
            }
            case 62: {
                this.map.clearObjects();
                this.updateZone();
                break;
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float v, float v1) {
        return false;
    }
}

