/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.tpwar.Teleports;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.menu.AvatarInputName;
import com.tpwar.game.windows.menu.FractionButton;
import packet.Static;

public class RegistrationScreenTest
implements Screen {
    private WindowManager windowManager = WindowManager.getInstance();
    private TextureAtlas atlas;
    private Stage stage;
    private Viewport viewport;
    private Stage uiStage;
    private Viewport uiViewport;
    private Image background;
    private FractionButton backButton;
    private FractionButton frontButton;
    private Array<FractionButton> fractionButtons = new Array(2);
    private AvatarInputName avatarInputName;

    public RegistrationScreenTest(Teleports app) {
    }

    @Override
    public void show() {
        this.atlas = new TextureAtlas(Gdx.files.internal("menu/main_menu.atlas"));
        this.background = new Image(this.atlas.findRegion("back"));
        this.viewport = new FitViewport(1024.0f, 576.0f);
        this.stage = new Stage(this.viewport);
        this.stage.addActor(this.background);
        this.uiViewport = new FillViewport(1024.0f, 576.0f);
        this.uiStage = new Stage(this.uiViewport);
        this.windowManager.setStage(this.uiStage);
        this.avatarInputName = new AvatarInputName(this.atlas);
        this.avatarInputName.setPosition(640.0f, 300.0f);
        this.avatarInputName.getColor().a = 0.0f;
        this.stage.addActor(this.avatarInputName);
        SelectFractionClickListener clickListener = new SelectFractionClickListener();
        Static.StaticFaction.Builder oseonFraction = Static.StaticFaction.newBuilder();
        oseonFraction.setCode("osion");
        oseonFraction.setHomePlanetId(1L);
        oseonFraction.setId(1L);
        oseonFraction.setName("Oseon");
        this.createAndAddFractionBtn(oseonFraction.build(), 180.0f, 145.0f, clickListener);
        Static.StaticFaction.Builder waylandFraction = Static.StaticFaction.newBuilder();
        waylandFraction.setCode("weyland");
        waylandFraction.setHomePlanetId(2L);
        waylandFraction.setId(2L);
        waylandFraction.setName("Wayland");
        this.createAndAddFractionBtn(waylandFraction.build(), 590.0f, 145.0f, clickListener);
        Gdx.input.setInputProcessor(new InputMultiplexer(this.stage, this.uiStage));
    }

    private FractionButton createAndAddFractionBtn(Static.StaticFaction fraction, float x, float y, ClickListener clickListener) {
        FractionButton fractionBtn = new FractionButton(this.atlas, fraction);
        fractionBtn.setPosition(x, y);
        fractionBtn.addListener(clickListener);
        this.stage.addActor(fractionBtn);
        this.fractionButtons.add(fractionBtn);
        return fractionBtn;
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act();
        this.viewport.apply();
        this.stage.draw();
        this.uiStage.act();
        this.uiViewport.apply();
        this.uiStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.uiViewport.update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.atlas.dispose();
        Gdx.input.setInputProcessor(null);
        this.stage.dispose();
        this.uiStage.dispose();
    }

    private class SelectFractionClickListener
    extends ClickListener {
        boolean flag = true;

        private SelectFractionClickListener() {
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            SequenceAction moveToBack = Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(140.0f, 155.0f, 0.3f, Interpolation.swingIn), (Action)Actions.scaleTo(0.92f, 0.92f, 0.3f)), (Action)Actions.run(new Runnable(){

                @Override
                public void run() {
                    RegistrationScreenTest.this.backButton.setZIndex(1);
                }
            }));
            SequenceAction moveToFront = Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(200.0f, 145.0f, 0.3f, Interpolation.swingIn), (Action)Actions.scaleTo(1.0f, 1.0f, 0.3f)), (Action)Actions.run(new Runnable(){

                @Override
                public void run() {
                    RegistrationScreenTest.this.backButton.setZIndex(1);
                }
            }));
            FractionButton button = (FractionButton)event.getTarget();
            if (RegistrationScreenTest.this.backButton == null) {
                if (button == RegistrationScreenTest.this.fractionButtons.get(0)) {
                    this.flag = false;
                }
                RegistrationScreenTest.this.avatarInputName.addAction(Actions.alpha(1.0f, 0.4f, Interpolation.exp5In));
            }
            if (this.flag) {
                RegistrationScreenTest.this.backButton = RegistrationScreenTest.this.fractionButtons.get(0);
                RegistrationScreenTest.this.frontButton = RegistrationScreenTest.this.fractionButtons.get(1);
                RegistrationScreenTest.this.backButton.addAction(moveToBack);
                RegistrationScreenTest.this.frontButton.addAction(moveToFront);
            } else {
                RegistrationScreenTest.this.backButton = RegistrationScreenTest.this.fractionButtons.get(1);
                RegistrationScreenTest.this.frontButton = RegistrationScreenTest.this.fractionButtons.get(0);
                RegistrationScreenTest.this.backButton.addAction(moveToBack);
                RegistrationScreenTest.this.frontButton.addAction(moveToFront);
            }
            this.flag = !this.flag;
        }
    }
}

