/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.tpwar.game.maps.Tpmap;
import com.tpwar.game.utils.Assets;
import packet.Static;

public class UnitTestScreen
implements Screen,
AnimationState.AnimationStateListener {
    private static final Array<Vector2> attackAnimationOffset = new Array(5);
    private Vector2 originalPosition;
    private SkeletonRenderer skeletonRenderer;
    protected Skeleton skeleton;
    protected AnimationStateData stateData;
    protected AnimationState state;
    protected Batch batch;
    private Assets assets;
    private OrthographicCamera camera;
    private int index;
    private Tpmap map;
    private OrthogonalTiledMapRenderer renderer;
    private FillViewport viewport;

    public UnitTestScreen() {
        attackAnimationOffset.add(new Vector2(-576.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(-288.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(0.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(288.0f, 0.0f));
        attackAnimationOffset.add(new Vector2(576.0f, 0.0f));
        this.originalPosition = new Vector2();
        this.assets = Assets.getInstance();
        this.index = 2;
        this.skeletonRenderer = new SkeletonRenderer();
        this.skeletonRenderer.setPremultipliedAlpha(true);
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(true);
        this.viewport = new FillViewport(1024.0f, 576.0f, this.camera);
        this.batch = new SpriteBatch();
        SkeletonData skeletonData = this.assets.get("units/unit_CLOSE_ALL_f.json", SkeletonData.class);
        this.skeleton = new Skeleton(skeletonData);
        this.skeleton.setPosition(400.0f, 400.0f);
        this.stateData = new AnimationStateData(skeletonData);
        this.state = new AnimationState(this.stateData);
        this.state.setAnimation(0, "up", false);
        this.state.addAnimation(0, "fly_f_" + this.index, false, 0.0f);
        this.state.addAnimation(0, "attack", false, 0.0f);
        this.state.addAnimation(0, "fly_b_" + this.index, false, 0.0f);
        this.state.addAnimation(0, "down", false, 0.0f);
        this.state.addAnimation(0, "stand", true, 0.0f);
        this.map = new Tpmap();
        Static.StaticZone currentZone = Static.StaticZone.newBuilder().setId(1L).setMapFileName("oseon_1").setPlanetId(1L).setPosition(1).build();
        this.map.load(currentZone, null, null);
        this.renderer = new OrthogonalTiledMapRenderer((TiledMap)this.map, this.batch);
        this.state.addListener(this);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.state.update(delta);
        if (this.state.apply(this.skeleton)) {
            this.skeleton.updateWorldTransform();
        }
        this.camera.update();
        this.batch.getProjectionMatrix().set(this.camera.combined);
        this.viewport.apply();
        this.renderer.render();
        this.batch.begin();
        this.skeletonRenderer.draw(this.batch, this.skeleton);
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.setToOrtho(false);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void start(AnimationState.TrackEntry entry) {
        if (entry.getAnimation().getName().equals("attack")) {
            this.originalPosition.set(this.skeleton.getX(), this.skeleton.getY());
            Gdx.app.log("start", entry.toString());
            this.skeleton.setX(this.skeleton.getX() + UnitTestScreen.attackAnimationOffset.get((int)(this.index - 1)).x);
            this.skeleton.setY(this.skeleton.getY() + UnitTestScreen.attackAnimationOffset.get((int)(this.index - 1)).y);
        }
    }

    @Override
    public void interrupt(AnimationState.TrackEntry entry) {
    }

    @Override
    public void end(AnimationState.TrackEntry entry) {
        if (entry.getAnimation().getName().equals("attack")) {
            this.skeleton.setX(this.originalPosition.x);
            this.skeleton.setY(this.originalPosition.y);
        }
    }

    @Override
    public void dispose(AnimationState.TrackEntry entry) {
    }

    @Override
    public void complete(AnimationState.TrackEntry entry) {
    }

    @Override
    public void event(AnimationState.TrackEntry entry, Event event) {
    }
}

