/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.camera;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;

public class CameraController
extends GestureDetector.GestureAdapter {
    private final OrthographicCamera camera;
    private float scrollRatio = 1.0f;
    public boolean isPanMode = false;
    private Vector3 target = new Vector3();

    public CameraController(Stage stage) {
        this.camera = (OrthographicCamera)stage.getCamera();
    }

    public void follow(Vector3 target) {
        this.target = target;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (this.isPanMode) {
            this.camera.translate(-deltaX * this.camera.zoom * this.scrollRatio, deltaY * this.camera.zoom * this.scrollRatio);
        }
        return super.pan(x, y, deltaX, deltaY);
    }

    @Override
    public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
        if (initialPointer1.x < pointer1.x && initialPointer2.x > pointer2.x) {
            this.isPanMode = true;
        } else if (initialPointer1.x > pointer1.x && initialPointer2.x < pointer2.x) {
            this.isPanMode = false;
        }
        return super.pinch(initialPointer1, initialPointer2, pointer1, pointer2);
    }

    public void update() {
        if (!this.isPanMode) {
            this.camera.position.lerp(this.target, 0.1f);
        }
    }

    public void setScrollRatio(float scrollRatio) {
        this.scrollRatio = scrollRatio;
    }
}

