/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.observer;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.events.EventListener;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;

public class ObserverBlockingListener
extends InputListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Commander commander = Commander.getInstance();
    private boolean enableTouch = false;

    public ObserverBlockingListener() {
        this.windowManager.addListener(1, new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow data) {
                ObserverBlockingListener.this.enableTouch = true;
            }
        });
        this.windowManager.addListener(2, new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow data) {
                ObserverBlockingListener.this.enableTouch = false;
            }
        });
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        if (!this.enableTouch) {
            event.cancel();
            this.showBlockWindow();
        }
        return super.touchDown(event, x, y, pointer, button);
    }

    @Override
    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
        if (!this.enableTouch) {
            event.cancel();
        }
        super.touchUp(event, x, y, pointer, button);
    }

    private void showBlockWindow() {
        String message = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u043e\u043a\u0438\u043d\u0443\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f?";
        final WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", message, "\u0414\u0430");
        wnd.setActionlistener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ObserverBlockingListener.this.commander.BattleActionExit();
                event.getStage().removeCaptureListener(this);
                wnd.closeHandler();
            }
        });
        this.windowManager.open(wnd, true);
    }
}

