/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.preloader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class CircularLoader
extends Actor {
    private final ShapeRenderer shapeRenderer;
    private float progress = 0.0f;
    private float rotation = 0.0f;
    private float radius = 40.0f;
    private float strokeWidth = 8.0f;
    private Color color = new Color(0.2f, 0.6f, 1.0f, 1.0f);
    private boolean indeterminate = false;
    private static final Color TRACK_COLOR = new Color(659190527);

    public CircularLoader() {
        this.shapeRenderer = new ShapeRenderer();
        this.setSize(this.radius * 2.0f + this.strokeWidth, this.radius * 2.0f + this.strokeWidth);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.setSize(radius * 2.0f + this.strokeWidth, radius * 2.0f + this.strokeWidth);
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.setSize(this.radius * 2.0f + strokeWidth, this.radius * 2.0f + strokeWidth);
    }

    @Override
    public void setColor(Color color) {
        this.color = color.cpy();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
    }

    public void setProgress(float progress) {
        this.progress = MathUtils.clamp(progress, 0.0f, 1.0f);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.indeterminate) {
            this.rotation += 180.0f * delta;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (!this.isVisible()) {
            return;
        }
        batch.end();
        float cx = this.getX() + this.getWidth() * 0.5f;
        float cy = this.getY() + this.getHeight() * 0.5f;
        if (this.getStage() != null && this.getStage().getCamera() != null) {
            this.shapeRenderer.setProjectionMatrix(this.getStage().getCamera().combined);
        } else {
            this.shapeRenderer.setProjectionMatrix(batch.getProjectionMatrix());
        }
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        float trackAlpha = CircularLoader.TRACK_COLOR.a;
        float progressAlpha = this.color.a;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 32970);
        this.shapeRenderer.setColor(CircularLoader.TRACK_COLOR.r, CircularLoader.TRACK_COLOR.g, CircularLoader.TRACK_COLOR.b, trackAlpha * 0.4f);
        this.drawThickArc(this.shapeRenderer, cx, cy, this.radius + 0.5f, this.strokeWidth + 1.0f, 0.0f, 360.0f, 96);
        this.shapeRenderer.setColor(CircularLoader.TRACK_COLOR.r, CircularLoader.TRACK_COLOR.g, CircularLoader.TRACK_COLOR.b, trackAlpha);
        this.drawThickArc(this.shapeRenderer, cx, cy, this.radius, this.strokeWidth, 0.0f, 360.0f, 96);
        this.shapeRenderer.setColor(this.color.r, this.color.g, this.color.b, progressAlpha);
        if (this.indeterminate) {
            this.drawThickArc(this.shapeRenderer, cx, cy, this.radius, this.strokeWidth, this.rotation, 90.0f, 96);
        } else {
            this.drawThickArc(this.shapeRenderer, cx, cy, this.radius, this.strokeWidth, 0.0f, 360.0f * this.progress, 96);
        }
        this.shapeRenderer.end();
        batch.begin();
    }

    private void drawThickArc(ShapeRenderer sr, float cx, float cy, float outerR, float width, float startDeg, float sweepDeg, int segments) {
        if (segments < 4) {
            segments = 4;
        }
        float innerR = outerR - width;
        float step = sweepDeg / (float)segments;
        for (int i = 0; i <= segments; ++i) {
            float angle1 = (float)Math.PI / 180 * (startDeg + step * (float)i);
            float angle2 = (float)Math.PI / 180 * (startDeg + step * (float)(i + 1));
            if (i == segments) break;
            float cos1 = MathUtils.cos(angle1);
            float sin1 = MathUtils.sin(angle1);
            float cos2 = MathUtils.cos(angle2);
            float sin2 = MathUtils.sin(angle2);
            float x1o = cx + cos1 * outerR;
            float y1o = cy + sin1 * outerR;
            float x1i = cx + cos1 * innerR;
            float y1i = cy + sin1 * innerR;
            float x2o = cx + cos2 * outerR;
            float y2o = cy + sin2 * outerR;
            float x2i = cx + cos2 * innerR;
            float y2i = cy + sin2 * innerR;
            sr.triangle(x1o, y1o, x1i, y1i, x2i, y2i);
            sr.triangle(x1o, y1o, x2i, y2i, x2o, y2o);
        }
    }

    @Override
    public boolean remove() {
        this.dispose();
        return super.remove();
    }

    public void dispose() {
        this.shapeRenderer.dispose();
    }
}

