/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.shaker;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.tpwar.game.screens.shaker.ShakeAction;
import java.util.Random;

public class ShakeCircle
extends ShakeAction {
    private Random random = new Random();
    private float originalRadius;
    private float radius;
    private float randomAngle;

    public ShakeCircle(float radius, float duration) {
        super(duration);
        this.originalRadius = radius;
        this.randomAngle = this.random.nextFloat() % 360.0f;
        this.radius = this.originalRadius;
    }

    @Override
    boolean update(float delta, OrthographicCamera camera) {
        if (this.elapsed < this.duration) {
            this.radius *= 0.9f;
            this.randomAngle += 150.0f + this.random.nextFloat() % 60.0f;
            float x = (float)(Math.sin(this.randomAngle) * (double)this.radius);
            float y = (float)(Math.cos(this.randomAngle) * (double)this.radius);
            camera.translate(-x, -y);
            this.elapsed += delta;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.radius = this.originalRadius;
        this.elapsed = 0.0f;
        this.randomAngle = this.random.nextFloat() % 360.0f;
    }
}

