/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.shaker;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.tpwar.game.screens.shaker.ShakeAction;
import java.util.Random;

public class ShakeHit
extends ShakeAction {
    private Random random = new Random();
    private float intensity;
    private Vector2 damageDirection;

    public ShakeHit(Vector2 damageDirection, float intensity, float duration) {
        super(duration);
        this.damageDirection = damageDirection;
        this.intensity = intensity;
    }

    @Override
    boolean update(float delta, OrthographicCamera camera) {
        if (this.elapsed < this.duration) {
            float currentPower = this.intensity * camera.zoom * ((this.duration - this.elapsed) / this.duration);
            float x = (this.random.nextFloat() - 0.5f) * 2.0f * currentPower * this.damageDirection.x;
            float y = (this.random.nextFloat() - 0.5f) * 2.0f * currentPower * this.damageDirection.y;
            camera.translate(-x, -y);
            this.elapsed += delta;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.elapsed = 0.0f;
    }
}

