/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.screens.shaker;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.tpwar.game.screens.shaker.ShakeAction;
import java.util.Random;

public class ShakePower
extends ShakeAction {
    private Random random = new Random();
    private float intensity;

    public ShakePower(float intensity, float duration) {
        super(duration);
        this.intensity = intensity;
    }

    @Override
    boolean update(float delta, OrthographicCamera camera) {
        if (this.elapsed < this.duration) {
            float currentPower = this.intensity * camera.zoom * ((this.duration - this.elapsed) / this.duration);
            float x = (this.random.nextFloat() - 0.5f) * 2.0f * currentPower;
            float y = (this.random.nextFloat() - 0.5f) * 2.0f * currentPower;
            camera.translate(-x, -y);
            this.elapsed += delta;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.elapsed = 0.0f;
    }
}

