/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.I18NBundleLoader;
import com.badlogic.gdx.assets.loaders.ShaderProgramLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.I18NBundle;
import com.esotericsoftware.spine.SkeletonData;
import com.tpwar.game.maps.data.AdobeAtlas;
import com.tpwar.game.maps.data.TpmapData;
import com.tpwar.game.utils.Constants;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.utils.loaders.AdobeAtlasLoader;
import com.tpwar.game.utils.loaders.SkeletonDataLoader;
import com.tpwar.game.utils.loaders.TpmapLoader;
import java.util.Locale;

public class Assets
extends AssetManager {
    private static final Assets instance = new Assets();
    private static final String RUSSIAN_CHARACTERS = "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f0123456789\u0456\u0457\u20bd\u00a9\u00ae\u2122\u2713\\\u00b0\u00a2$\u20ac\u00a3~`|\u2022\u221a\u03c0\u00f7\u00d7\u2116";
    private AssetFont font;
    private AssetUI ui;
    private Skin defaultSkin;

    public Assets() {
    }

    public Assets(FileHandleResolver resolver) {
        super(resolver);
    }

    public Assets(FileHandleResolver resolver, boolean defaultLoaders) {
        super(resolver, defaultLoaders);
    }

    public void load() {
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        this.setLoader(TpmapData.class, new TpmapLoader(resolver));
        this.setLoader(AdobeAtlas.class, new AdobeAtlasLoader(resolver));
        this.setLoader(SkeletonData.class, new SkeletonDataLoader(resolver));
        this.setLoader(ShaderProgram.class, new ShaderProgramLoader(resolver));
        this.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        this.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        this.loadFonts();
        this.loadShaders();
        AdobeAtlasLoader.AdobeAtlasParameter params = new AdobeAtlasLoader.AdobeAtlasParameter(null, false, false);
        params.textureParam = new TextureLoader.TextureParameter();
        params.textureParam.minFilter = Texture.TextureFilter.Nearest;
        params.textureParam.magFilter = Texture.TextureFilter.Linear;
        params.textureParam.genMipMaps = true;
        this.load("maps/grass.json", AdobeAtlas.class, params);
        params = new AdobeAtlasLoader.AdobeAtlasParameter(null, false, false);
        params.textureParam = new TextureLoader.TextureParameter();
        params.textureParam.minFilter = Texture.TextureFilter.Linear;
        params.textureParam.magFilter = Texture.TextureFilter.Nearest;
        params.textureParam.genMipMaps = true;
        this.load("maps/stones.json", AdobeAtlas.class, params);
        this.load("maps/aqua.json", AdobeAtlas.class, params);
        this.load("maps/trees.json", AdobeAtlas.class, params);
        for (String mapPath : Constants.MAPS) {
            this.load(mapPath, TpmapData.class);
        }
        this.load("maps/map_artefacts.atlas", TextureAtlas.class);
        this.load("buildings/buildings.atlas", TextureAtlas.class);
        this.load("entity/entity_elements.atlas", TextureAtlas.class);
        this.load("entity/std_oseon.atlas", TextureAtlas.class);
        this.load("entity/std_wayland.atlas", TextureAtlas.class);
        this.load("entity/wrestler.atlas", TextureAtlas.class);
        this.load("entity/marine.atlas", TextureAtlas.class);
        SkeletonDataLoader.SkeletonDataLoaderParameter unitParameters = new SkeletonDataLoader.SkeletonDataLoaderParameter(1.0f);
        this.load("units/unit_FAR_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/unit_FAR_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/unit_CLOSE_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/unit_CLOSE_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/unit_HEAVY_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/unit_HEAVY_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_FAR_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_FAR_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_CLOSE_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_CLOSE_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_HEAVY_ALL_b.json", SkeletonData.class, unitParameters);
        this.load("units/oseon/unit_HEAVY_ALL_f.json", SkeletonData.class, unitParameters);
        this.load("units/cursors.json", SkeletonData.class, unitParameters);
        this.load("units/battle_elements.atlas", TextureAtlas.class);
        this.loadUI();
        this.loadI18n();
        this.loadMusic();
    }

    public void loadExtraSkin() {
        TextureLoader.TextureParameter textureParam = new TextureLoader.TextureParameter();
        textureParam.minFilter = Texture.TextureFilter.Linear;
        textureParam.magFilter = Texture.TextureFilter.Linear;
        for (int i = 1; i <= 25; ++i) {
            this.load("entity/" + i + ".png", Texture.class, textureParam);
        }
        this.finishLoading();
    }

    private void loadFonts() {
        FreetypeFontLoader.FreeTypeFontLoaderParameter parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/Century Gothic.ttf";
        parms.fontParameters.size = 24;
        parms.fontParameters.borderColor = Color.BLACK;
        parms.fontParameters.borderWidth = 1.0f;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".concat(RUSSIAN_CHARACTERS);
        this.load("CenturyGothic_24.ttf", BitmapFont.class, parms);
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/GOTHICB.TTF";
        parms.fontParameters.size = 40;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.characters = "1234567890";
        this.load("CenturyGothic_40.ttf", BitmapFont.class, parms);
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/GOTHICB.TTF";
        parms.fontParameters.size = 14;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".concat(RUSSIAN_CHARACTERS);
        this.load("CenturyGothic_14.ttf", BitmapFont.class, parms);
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/Verdana-Bold.ttf";
        parms.fontParameters.size = 12;
        parms.fontParameters.borderColor = Color.GRAY;
        parms.fontParameters.borderWidth = 0.8f;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        this.load("Verdana-Bold_12.ttf", BitmapFont.class, parms);
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/Verdana-Bold.ttf";
        parms.fontParameters.size = 16;
        parms.fontParameters.magFilter = Texture.TextureFilter.Nearest;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".concat(RUSSIAN_CHARACTERS);
        this.load("Verdana-Bold_14.ttf", BitmapFont.class, parms);
        parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/arialbd.ttf";
        parms.fontParameters.size = 16;
        parms.fontParameters.hinting = FreeTypeFontGenerator.Hinting.None;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".concat(RUSSIAN_CHARACTERS);
        this.load("arialbd_16.ttf", BitmapFont.class, parms);
        this.load("fonts/arial_12.fnt", BitmapFont.class);
        this.load("fonts/arial_14.fnt", BitmapFont.class);
        this.load("fonts/arial_16.fnt", BitmapFont.class);
        this.load("fonts/arial_14_bold.fnt", BitmapFont.class);
        this.load("fonts/arial_25_bold_numbers.fnt", BitmapFont.class);
        this.load("fonts/centry_gothic_15.fnt", BitmapFont.class);
        this.load("fonts/centry_gothic_20.fnt", BitmapFont.class);
        this.load("fonts/centry_gothic_bold_25.fnt", BitmapFont.class);
        this.load("fonts/centry_gothic_bold_20.fnt", BitmapFont.class);
    }

    private void loadMusic() {
        this.load("sound/fx/7. Click_Usual.mp3", Sound.class);
        this.load("sound/fx/1. Open_Window.mp3", Sound.class);
        this.load("sound/fx/2. Close_Window.mp3", Sound.class);
        this.load("sound/music/10 - Alert.mp3", Sound.class);
        this.load("sound/fx/3. Buy.mp3", Sound.class);
        this.load("sound/fx/4. Sell.mp3", Sound.class);
        this.load("sound/fx/5. Teleport (move to a new planet, enter the game).mp3", Sound.class);
        this.load("sound/fx/6. Mail_Incoming.mp3", Sound.class);
        this.load("sound/fx/13. Select_Unit (train_unit).mp3", Sound.class);
        this.load("sound/fx/14. Artifact - Dynamic_Shield.mp3", Sound.class);
        this.load("sound/fx/15. Artifact - Double_Strength.mp3", Sound.class);
        this.load("sound/fx/16. Artifact - Healing.mp3", Sound.class);
        this.load("sound/fx/17. Artifact - Beam_of_Death.mp3", Sound.class);
        this.load("sound/fx/10. Hummer_Beam.mp3", Sound.class);
        this.load("sound/fx/11. Hit_into_shield.mp3", Sound.class);
        this.load("sound/fx/12. Unit_death.mp3", Sound.class);
        this.load("sound/fx/8. Striker_Hit.mp3", Sound.class);
        this.load("sound/fx/9. Blaser_Shot.mp3", Sound.class);
        this.load("sound/fx/18. Capture_a_Portal.mp3", Sound.class);
        this.load("sound/fx/19. Capture_a_Mine.mp3", Sound.class);
        this.load("sound/fx/20. Capture_a_Citadel.mp3", Sound.class);
        this.load("sound/fx/21. Leave portal, mine, digg.mp3", Sound.class);
        this.load("sound/fx/22. Start_treasure_digging.mp3", Sound.class);
        this.load("sound/fx/23. Successfull_mine, dig, pryanik.mp3", Sound.class);
        this.load("sound/fx/24. Join_guild.mp3", Sound.class);
        this.load("sound/fx/25. Buy_time_booster.mp3", Sound.class);
        this.load("sound/fx/26. Buy_time_slower.mp3", Sound.class);
        this.load("sound/fx/27. Set_slot.mp3", Sound.class);
        this.load("sound/fx/28. Buy_crystal.mp3", Sound.class);
        this.load("sound/fx/29. Exchange_crystal_to_energy.mp3", Sound.class);
        this.load("sound/music/14 - New level.mp3", Sound.class);
        this.load("sound/music/Battle start.mp3", Sound.class);
        this.load("sound/music/12 - Battle end.mp3", Sound.class);
        this.load("sound/music/Battle new round.mp3", Sound.class);
        this.load("sound/fx/30. Timer_10 sec.mp3", Sound.class);
    }

    private void loadShaders() {
        ShaderProgramLoader.ShaderProgramParameter params = new ShaderProgramLoader.ShaderProgramParameter();
        params.fragmentFile = "shaders/tint.frag";
        params.vertexFile = "shaders/default.vert";
        this.load("tint_shader", ShaderProgram.class, params);
    }

    private void loadUI() {
        this.load("ui/common.atlas", TextureAtlas.class);
        this.load("ui/barrack.atlas", TextureAtlas.class);
        this.load("ui/window.atlas", TextureAtlas.class);
        this.load("ui/profile.atlas", TextureAtlas.class);
        this.load("ui/workshop.atlas", TextureAtlas.class);
        this.load("ui/hud.atlas", TextureAtlas.class);
    }

    private void loadI18n() {
        String language = LocalSettings.getInstance().getLang();
        Locale locale = new Locale(language);
        Gdx.app.log(this.getClass().getSimpleName(), "Lang " + locale.getLanguage());
        I18NBundleLoader.I18NBundleParameter params = new I18NBundleLoader.I18NBundleParameter(locale);
        this.load("i18n/bundle", I18NBundle.class, params);
    }

    public void generateSkin() {
        this.font = new AssetFont();
        this.defaultSkin = new Skin();
        TextureAtlas windowAtlas = this.getWindowAtlas();
        this.defaultSkin.addRegions(windowAtlas);
        this.defaultSkin.add("arial-bold-14", this.font.arialBold14);
        this.defaultSkin.add("arial-bold-16", this.font.arialBold16);
        this.defaultSkin.add("centry-gothic-24", this.font.centryGothic24);
        this.defaultSkin.add("arial-bold-14", new Label.LabelStyle(this.font.arialBold14, Color.WHITE));
        this.defaultSkin.add("arial-bold-16", new Label.LabelStyle(this.font.arialBold16, Color.WHITE));
        TextButton.TextButtonStyle yitbs = new TextButton.TextButtonStyle();
        yitbs.up = this.defaultSkin.getDrawable("yellow_btn_up");
        yitbs.over = this.defaultSkin.getDrawable("yellow_btn_over");
        yitbs.down = this.defaultSkin.getDrawable("yellow_btn_down");
        yitbs.disabled = this.defaultSkin.getDrawable("yellow_btn_disable");
        yitbs.font = this.font.arialBold14;
        yitbs.fontColor = Color.valueOf("#3A3631");
        this.defaultSkin.add("yellow-btn", yitbs);
        ImageButton.ImageButtonStyle cibs = new ImageButton.ImageButtonStyle();
        cibs.up = this.defaultSkin.getDrawable("close_btn_up");
        cibs.down = this.defaultSkin.getDrawable("close_btn_down");
        this.defaultSkin.add("close-btn", cibs);
        Pixmap pixmap = new Pixmap(32, 32, Pixmap.Format.RGBA8888);
        Color color = Color.DARK_GRAY.cpy();
        color.a = 0.4f;
        pixmap.setColor(color);
        pixmap.fillRectangle(0, 0, 32, 32);
        TextureRegion stageBackgroundTexture = new TextureRegion(new Texture(pixmap));
        pixmap.dispose();
        TextureAtlas commonTextureAtlas = (TextureAtlas)this.get("ui/common.atlas");
        Window.WindowStyle windowStyle = new Window.WindowStyle();
        windowStyle.titleFont = this.font.centryGothic24;
        NinePatch ninePatch = new NinePatch((TextureRegion)commonTextureAtlas.findRegion("win_bg"), 10, 10, 10, 10);
        windowStyle.background = new NinePatchDrawable(ninePatch);
        windowStyle.stageBackground = new TextureRegionDrawable(stageBackgroundTexture);
        this.defaultSkin.add("default", windowStyle);
        NinePatch tutorialNinePatchBackground = new NinePatch((TextureRegion)commonTextureAtlas.findRegion("blurred_background"), 50, 50, 10, 10);
        Window.WindowStyle tutorialWindowStyle = new Window.WindowStyle();
        tutorialWindowStyle.background = new NinePatchDrawable(tutorialNinePatchBackground);
        tutorialWindowStyle.titleFont = this.font.centryGothic24;
        this.defaultSkin.add("tutorial", tutorialWindowStyle);
        this.ui = new AssetUI();
    }

    public TextureAtlas getWindowAtlas() {
        return (TextureAtlas)this.get("ui/window.atlas");
    }

    public TextureAtlas getCommonAtlas() {
        return (TextureAtlas)this.get("ui/common.atlas");
    }

    public TextureRegionDrawable getColoredDrawable(int width, int height, Color color) {
        Pixmap pixmap = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        pixmap.setColor(color);
        pixmap.fill();
        Texture texture = new Texture(pixmap);
        pixmap.dispose();
        return new TextureRegionDrawable(new TextureRegion(texture));
    }

    public Array<TextureRegion> extractRegions(TextureAtlas atlas, String name) {
        Array<TextureRegion> result = new Array<TextureRegion>();
        for (TextureAtlas.AtlasRegion region : atlas.getRegions()) {
            if (!region.name.contains(name)) continue;
            result.add(region);
        }
        return result;
    }

    public NinePatchDrawable getNinePatchDrawable(TextureAtlas atlas, String name, int left, int right, int top, int bottom) {
        return new NinePatchDrawable(this.getNinePatch(atlas, name, left, right, top, bottom));
    }

    public NinePatch getNinePatch(TextureAtlas atlas, String name, int left, int right, int top, int bottom) {
        return new NinePatch((TextureRegion)atlas.findRegion(name), left, right, top, bottom);
    }

    public Drawable getDrawable(TextureAtlas atlas, String name, int index) {
        return new TextureRegionDrawable(atlas.findRegion(name, index));
    }

    public TextureRegionDrawable getDrawable(TextureAtlas atlas, String name) {
        return new TextureRegionDrawable(atlas.findRegion(name));
    }

    public static Assets getInstance() {
        return instance;
    }

    public Skin getDefaultSkin() {
        return this.defaultSkin;
    }

    public AssetFont getFont() {
        return this.font;
    }

    public AssetUI getUi() {
        return this.ui;
    }

    public class AssetFont {
        public final BitmapFont verdana12;
        public final BitmapFont verdana16;
        public final BitmapFont arial12;
        public final BitmapFont arial14;
        public final BitmapFont arial16;
        public final BitmapFont arialBold14;
        public final BitmapFont arialBold16;
        public final BitmapFont arialBold25Numbers;
        public final BitmapFont centryGothic15;
        public final BitmapFont centryGothic20;
        public final BitmapFont centryGothic24;
        public final BitmapFont centryGothicBold20;
        public final BitmapFont centryGothicBold25;
        public final BitmapFont centryGothicBold40;
        public final BitmapFont centryGothicBold14;

        public AssetFont() {
            this.verdana12 = (BitmapFont)Assets.this.get("Verdana-Bold_12.ttf");
            this.verdana16 = (BitmapFont)Assets.this.get("Verdana-Bold_14.ttf");
            this.arial12 = (BitmapFont)Assets.this.get("fonts/arial_12.fnt");
            this.arial14 = (BitmapFont)Assets.this.get("fonts/arial_14.fnt");
            this.arial14.getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.arial16 = (BitmapFont)Assets.this.get("fonts/arial_16.fnt");
            this.arial16.getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.arialBold14 = (BitmapFont)Assets.this.get("fonts/arial_14_bold.fnt");
            this.arialBold14.getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.arialBold16 = (BitmapFont)Assets.this.get("arialbd_16.ttf");
            this.arialBold25Numbers = (BitmapFont)Assets.this.get("fonts/arial_25_bold_numbers.fnt");
            this.centryGothic15 = (BitmapFont)Assets.this.get("fonts/centry_gothic_15.fnt");
            this.centryGothic20 = (BitmapFont)Assets.this.get("fonts/centry_gothic_20.fnt");
            this.centryGothic24 = (BitmapFont)Assets.this.get("CenturyGothic_24.ttf");
            this.centryGothicBold14 = (BitmapFont)Assets.this.get("CenturyGothic_14.ttf");
            this.centryGothicBold20 = (BitmapFont)Assets.this.get("fonts/centry_gothic_bold_20.fnt");
            this.centryGothicBold25 = (BitmapFont)Assets.this.get("fonts/centry_gothic_bold_25.fnt");
            this.centryGothicBold40 = (BitmapFont)Assets.this.get("CenturyGothic_40.ttf");
        }
    }

    public class AssetUI {
        public final TextButton.TextButtonStyle yellowButtonStyle;
        public final TextButton.TextButtonStyle redButtonStyle;
        public final TextButton.TextButtonStyle buyButtonStyle;

        public AssetUI() {
            TextureAtlas windowAtlas = Assets.this.getWindowAtlas();
            this.yellowButtonStyle = new TextButton.TextButtonStyle();
            this.yellowButtonStyle.up = Assets.this.getNinePatchDrawable(windowAtlas, "yellow_btn_up", 4, 4, 4, 4);
            this.yellowButtonStyle.down = Assets.this.getNinePatchDrawable(windowAtlas, "yellow_btn_down", 4, 4, 4, 4);
            this.yellowButtonStyle.font = Assets.this.font.arialBold14;
            this.yellowButtonStyle.fontColor = Color.valueOf("#3A3631");
            this.redButtonStyle = new TextButton.TextButtonStyle();
            this.redButtonStyle.up = Assets.this.getNinePatchDrawable(windowAtlas, "red_btn_up", 10, 10, 4, 4);
            this.redButtonStyle.down = Assets.this.getNinePatchDrawable(windowAtlas, "red_btn_down", 10, 10, 4, 4);
            this.redButtonStyle.disabled = Assets.this.getNinePatchDrawable(windowAtlas, "red_btn_disable", 10, 10, 4, 4);
            this.redButtonStyle.font = Assets.this.font.arialBold14;
            this.buyButtonStyle = new TextButton.TextButtonStyle();
            this.buyButtonStyle.up = Assets.this.getNinePatchDrawable(windowAtlas, "buy_btn_up", 4, 28, 4, 4);
            this.buyButtonStyle.down = Assets.this.getNinePatchDrawable(windowAtlas, "buy_btn_down", 4, 28, 4, 4);
            this.buyButtonStyle.disabled = Assets.this.getNinePatchDrawable(windowAtlas, "buy_btn_disable", 4, 28, 4, 4);
            this.buyButtonStyle.font = Assets.this.font.arialBold14;
        }
    }
}

