/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Queue;

public class AutoClickerDetecter
extends InputAdapter {
    private static final AutoClickerDetecter INSTANCE = new AutoClickerDetecter();
    private static final int REITERATION_DETECT = 5;
    private static final int MIN_ITERATION_LEHGTH = 2;
    private static final int MAX_ITERATION_LEHGTH = 20;
    private static final int MAX_QUERY_LEGTH = 100;
    private Queue<Vector2> clickQuery = new Queue(100);

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.clickQuery.addFirst(new Vector2(screenX, screenY));
        if (this.clickQuery.size > 100) {
            this.clickQuery.removeLast();
        }
        if (this.clickQuery.size >= 10) {
            this.checkReiteration();
        }
        return false;
    }

    private void checkReiteration() {
        if (this.isReiteration()) {
            Gdx.app.log("", "AUTOCLICKER DETECTED");
            this.clickQuery.clear();
        }
    }

    private boolean isReiteration() {
        for (int l = 2; l < Math.min(this.clickQuery.size, 20); ++l) {
            int repeats = this.countRepeats(this.slice(this.clickQuery, 0, l));
            Gdx.app.log("repeats", "" + repeats);
            if (repeats < 5) continue;
            return true;
        }
        return false;
    }

    public Array<Vector2> slice(Queue<Vector2> values, int start, int end) {
        Array<Vector2> result = new Array<Vector2>(end - start);
        for (int i = start; i < end; ++i) {
            result.add(values.get(i));
        }
        return result;
    }

    private int countRepeats(Array<Vector2> checkIteration) {
        int i;
        if (!this.isIterationForCheck(checkIteration)) {
            return 0;
        }
        for (i = checkIteration.size; i < this.clickQuery.size; ++i) {
            int j = i % checkIteration.size;
            if (this.areDifferent(this.clickQuery.get(i), checkIteration.get(j))) break;
        }
        return (int)Math.floor(i / checkIteration.size);
    }

    private boolean isIterationForCheck(Array<Vector2> checkIteration) {
        for (int i = 0; i < checkIteration.size - 1; ++i) {
            if (!this.areDifferent(checkIteration.get(i), checkIteration.get(i + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean areDifferent(Vector2 a, Vector2 b) {
        return Math.abs(a.x - b.x) > 1.0f && Math.abs(a.y - b.y) > 1.0f;
    }

    public static AutoClickerDetecter getInstance() {
        return INSTANCE;
    }
}

