/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatFilter {
    private static final Set<String> badWords = Set.of("\u0445\u0443\u0439", "\u0445\u0443\u0451", "\u0445\u0443\u0435", "\u0445\u0443\u044f", "\u043f\u0438\u0437\u0434", "\u043f\u0438\u0437\u0434\u0435", "\u0431\u043b\u044f", "\u0431\u043b\u044f\u0434", "\u0435\u0431\u0430", "\u0435\u0431\u0435", "\u0435\u0431\u0451", "\u0435\u0431\u0438", "\u0435\u0431\u043d", "\u0433\u0430\u043d\u0434\u043e\u043d", "\u043f\u0438\u0434\u0430\u0440", "\u043f\u0438\u0434\u043e\u0440\u0430\u0441", "\u043c\u0443\u0434\u0430\u043a", "\u043c\u0443\u0434\u043e\u0437\u0432\u043e\u043d", "\u043f\u0440\u043e\u0435\u0431", "\u0448\u043b\u044e\u0445", "\u0448\u043b\u044e\u0448", "\u0447\u043c\u043e", "\u0443\u0435\u0431", "\u0441\u044a\u0435\u0431\u0438", "\u043f\u0435\u0440\u0434\u043e\u043b", "\u0435\u0431\u043b\u0435", "\u0435\u0431\u0435\u043d\u044f", "\u0435\u0431\u0443\u0442", "\u0445\u0443\u043b\u0438", "\u043f\u043d\u0445", "\u0431\u043b\u0435\u0432", "\u0433\u043e\u043d\u0434\u043e\u043d", "\u0434\u043e\u043b\u0431\u043e\u0451\u0431", "\u0437\u0430\u043b\u0443\u043f", "\u043a\u043e\u043d\u0447", "\u043c\u0430\u043d\u0434\u0430", "\u043c\u0440\u0430\u0437", "\u043f\u0435\u0434\u0438\u043a", "\u0441\u0443\u0447\u043a", "\u0442\u0440\u0430\u0445", "\u0444\u0430\u043a", "fuck", "asshole", "bitch", "dick");
    private static final char[] SYMBOLS = "!@#$*^%".toCharArray();
    private static final Random RANDOM = new Random();
    private final Pattern[] badWordPatterns;
    private final String[] replacements;

    public ChatFilter() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        ArrayList<String> repls = new ArrayList<String>();
        for (String badWord : badWords) {
            String patternStr = "(?i)\\b" + Pattern.quote(badWord) + "\\w*";
            patterns.add(Pattern.compile(patternStr));
            repls.add(this.generateReplacement(badWord.length()));
        }
        this.badWordPatterns = patterns.toArray(new Pattern[0]);
        this.replacements = repls.toArray(new String[0]);
    }

    private String generateReplacement(int length) {
        if (length <= 0) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(SYMBOLS[RANDOM.nextInt(SYMBOLS.length)]);
        }
        return sb.toString();
    }

    public String filter(String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        String result = message;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.badWordPatterns.length; ++i) {
            Pattern pattern = this.badWordPatterns[i];
            Matcher matcher = pattern.matcher(result);
            buffer.setLength(0);
            while (matcher.find()) {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(this.replacements[i]));
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        }
        return result;
    }
}

