/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;

public class Component {
    public static NinePatchDrawable getNinePatchDrawable(TextureAtlas atlas, String name, int left, int right, int top, int bottom) {
        return new NinePatchDrawable(Component.getNinePatch(atlas, name, left, right, top, bottom));
    }

    public static NinePatch getNinePatch(TextureAtlas atlas, String name, int left, int right, int top, int bottom) {
        return new NinePatch((TextureRegion)atlas.findRegion(name), left, right, top, bottom);
    }

    public static Image getImage(TextureAtlas atlas, String name) {
        return new Image(new TextureRegionDrawable(atlas.findRegion(name)));
    }

    public static Image getImage(TextureAtlas atlas, String name, int left, int right, int top, int bottom) {
        return new Image(Component.getNinePatchDrawable(atlas, name, left, right, top, bottom));
    }

    public static ImageButton getImageButton(TextureAtlas atlas, String upState, String downState) {
        TextureAtlas.AtlasRegion stateUp = atlas.findRegion(upState);
        TextureAtlas.AtlasRegion stateDown = atlas.findRegion(downState);
        ImageButton.ImageButtonStyle buttonStyle = new ImageButton.ImageButtonStyle();
        buttonStyle.up = new TextureRegionDrawable(stateUp);
        buttonStyle.down = new TextureRegionDrawable(stateDown);
        return new ImageButton(buttonStyle);
    }

    public static ImageButton getImageButton(TextureAtlas atlas, String upState, String downState, String disableState) {
        TextureAtlas.AtlasRegion stateUp = atlas.findRegion(upState);
        TextureAtlas.AtlasRegion stateDown = atlas.findRegion(downState);
        TextureAtlas.AtlasRegion stateDisable = atlas.findRegion(disableState);
        ImageButton.ImageButtonStyle buttonStyle = new ImageButton.ImageButtonStyle();
        buttonStyle.up = new TextureRegionDrawable(stateUp);
        buttonStyle.down = new TextureRegionDrawable(stateDown);
        buttonStyle.disabled = new TextureRegionDrawable(stateDisable);
        return new ImageButton(buttonStyle);
    }

    public static ImageButton getImageButton(TextureAtlas atlas, String prefixState) {
        Array<TextureAtlas.AtlasRegion> states = Component.extractRegions(atlas, prefixState);
        ImageButton.ImageButtonStyle buttonStyle = new ImageButton.ImageButtonStyle();
        switch (states.size) {
            case 4: {
                buttonStyle.up = new TextureRegionDrawable(states.get(0));
                buttonStyle.over = new TextureRegionDrawable(states.get(1));
                buttonStyle.down = new TextureRegionDrawable(states.get(2));
                buttonStyle.disabled = new TextureRegionDrawable(states.get(3));
                break;
            }
            case 3: {
                buttonStyle.disabled = new TextureRegionDrawable(states.get(2));
            }
            case 2: {
                buttonStyle.up = new TextureRegionDrawable(states.get(0));
                buttonStyle.down = new TextureRegionDrawable(states.get(1));
                break;
            }
            case 1: {
                buttonStyle.up = new TextureRegionDrawable(states.get(0));
                buttonStyle.down = new TextureRegionDrawable(states.get(0));
            }
        }
        return new ImageButton(buttonStyle);
    }

    public static ImageTextButton getImageTextButton(TextureAtlas atlas, String prefixState, BitmapFont font, String text) {
        return Component.getImageTextButton(atlas, prefixState, font, text, 4, 5, 5, 5, 5);
    }

    public static ImageTextButton getImageTextButton(TextureAtlas atlas, String prefixState, BitmapFont font, String text, int textOffsetY, int left, int right, int top, int bottom) {
        Array<TextureAtlas.AtlasRegion> states = Component.extractRegions(atlas, prefixState);
        ImageTextButton.ImageTextButtonStyle buttonStyle = new ImageTextButton.ImageTextButtonStyle();
        buttonStyle.font = font;
        buttonStyle.unpressedOffsetY = textOffsetY;
        buttonStyle.pressedOffsetY = textOffsetY;
        buttonStyle.checkedOffsetY = textOffsetY;
        switch (states.size) {
            case 4: {
                buttonStyle.up = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(0), left, right, top, bottom));
                buttonStyle.over = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(1), left, right, top, bottom));
                buttonStyle.down = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(2), left, right, top, bottom));
                buttonStyle.disabled = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(3), left, right, top, bottom));
                break;
            }
            case 3: {
                buttonStyle.disabled = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(2), left, right, top, bottom));
            }
            case 2: {
                buttonStyle.up = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(0), left, right, top, bottom));
                buttonStyle.down = new NinePatchDrawable(new NinePatch((TextureRegion)states.get(1), left, right, top, bottom));
            }
        }
        return new ImageTextButton(text, buttonStyle);
    }

    public static TextButton getImageTextButton(TextureAtlas atlas, String upState, String downState, BitmapFont font, String text) {
        TextButton.TextButtonStyle buttonStyle = new TextButton.TextButtonStyle();
        buttonStyle.up = Component.getNinePatchDrawable(atlas, upState, 10, 10, 10, 10);
        buttonStyle.down = Component.getNinePatchDrawable(atlas, downState, 10, 10, 10, 10);
        buttonStyle.font = font;
        return new TextButton(text, buttonStyle);
    }

    public static Array<TextureAtlas.AtlasRegion> extractRegions(TextureAtlas atlas, String name) {
        Array<TextureAtlas.AtlasRegion> result = new Array<TextureAtlas.AtlasRegion>();
        for (TextureAtlas.AtlasRegion region : atlas.getRegions()) {
            if (!region.name.startsWith(name)) continue;
            result.add(region);
        }
        return result;
    }
}

