/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.tpwar.payment.PlayerTransaction;
import java.util.Locale;
import packet.Payment;

public class LocalSettings {
    public static final String VIBRATION = "vibration";
    public static final String VIBRATION_IN_BATTLE = "vibration-in-battle";
    public static final String CHAT_AUTO_OPEN = "chat-auto-open";
    public static final String SOUND = "sound";
    public static final String MUSIC = "music";
    public static final String LEVEL_ICONS = "level_icons";
    public static final String TRANSACTIONS = "transactions";
    public static final String LANG = "language";
    public static final String GAME_NOTIFICATIONS = "main_notifications";
    public static final String PLAYER_NOTIFICATIONS = "player_notifications";
    public static final String LANG_RU = "ru";
    public static final String LANG_EN = "en";
    private static final LocalSettings instance = new LocalSettings();
    private Preferences prefs = Gdx.app.getPreferences("tpwar-settings");

    public static LocalSettings getInstance() {
        return instance;
    }

    public String getLang() {
        return this.prefs.getString(LANG, switch (language = Locale.getDefault().getLanguage()) {
            case LANG_RU, "be", "kk", "ky", "uk", "uz", "ce" -> LANG_RU;
            default -> LANG_EN;
        });
    }

    public void save(String name, String value) {
        this.prefs.putString(name, value);
        this.prefs.flush();
    }

    public boolean get(String name, boolean defaultValue) {
        return this.prefs.getBoolean(name, defaultValue);
    }

    public void enable(String name, boolean value) {
        this.prefs.putBoolean(name, value);
        this.prefs.flush();
    }

    public boolean sound() {
        return this.prefs.getBoolean(SOUND, true);
    }

    public boolean music() {
        return this.prefs.getBoolean(MUSIC, true);
    }

    public boolean vibration() {
        return this.prefs.getBoolean(VIBRATION, true);
    }

    public boolean levelIcons() {
        return this.prefs.getBoolean(LEVEL_ICONS, false);
    }

    public boolean vibrationInBattle() {
        return this.prefs.getBoolean(VIBRATION_IN_BATTLE, true);
    }

    public boolean chatAutoOpen() {
        return this.prefs.getBoolean(CHAT_AUTO_OPEN, true);
    }

    public void saveTransaction(PlayerTransaction pt) {
        Json json = new Json();
        String transactions = this.prefs.getString(TRANSACTIONS);
        ObjectMap<String, PlayerTransaction> map = json.fromJson(ObjectMap.class, PlayerTransaction.class, transactions);
        if (map != null) {
            if (map.containsKey(pt.transaction.getOrderId())) {
                return;
            }
        } else {
            map = new ObjectMap<String, PlayerTransaction>();
        }
        map.put(pt.transaction.getOrderId(), pt);
        this.prefs.putString(TRANSACTIONS, json.toJson(map));
        this.prefs.flush();
    }

    public ObjectMap<String, PlayerTransaction> transactions() {
        String transactions = this.prefs.getString(TRANSACTIONS);
        Json json = new Json();
        ObjectMap map = json.fromJson(ObjectMap.class, PlayerTransaction.class, transactions);
        return map;
    }

    public void transactionProcessed(Payment.PaymentDto paymentDto) {
        Json json = new Json();
        String transactions = this.prefs.getString(TRANSACTIONS);
        ObjectMap map = json.fromJson(ObjectMap.class, PlayerTransaction.class, transactions);
        if (map == null) {
            Gdx.app.error(this.getClass().getSimpleName(), "Payments map is null");
            return;
        }
        PlayerTransaction pt = (PlayerTransaction)map.get(paymentDto.getOrderId());
        if (pt == null) {
            return;
        }
        pt.processed = true;
        this.prefs.putString(TRANSACTIONS, json.toJson(map));
        this.prefs.flush();
    }
}

