/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.I18NBundleLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.utils.I18NBundle;
import com.tpwar.game.utils.HolidayUtils;
import com.tpwar.game.utils.LocalSettings;
import java.util.Locale;

public class StartingAssets
extends AssetManager {
    private String preloaderPath;

    public StartingAssets() {
    }

    public StartingAssets(FileHandleResolver resolver, boolean defaultLoaders) {
        super(resolver, defaultLoaders);
    }

    public StartingAssets(FileHandleResolver resolver) {
        super(resolver);
    }

    public void load() {
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        this.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        this.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        FreetypeFontLoader.FreeTypeFontLoaderParameter parms = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        parms.fontFileName = "fonts/arialbd.ttf";
        parms.fontParameters.size = 16;
        parms.fontParameters.magFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.minFilter = Texture.TextureFilter.Linear;
        parms.fontParameters.incremental = true;
        this.load("arialbd_16.ttf", BitmapFont.class, parms);
        TextureLoader.TextureParameter textureParms = new TextureLoader.TextureParameter();
        textureParms.minFilter = Texture.TextureFilter.Linear;
        textureParms.magFilter = Texture.TextureFilter.Linear;
        this.preloaderPath = HolidayUtils.isItHallowenDay() ? "preloader_hallowen.png" : "preloader_bg.png";
        this.load(this.preloaderPath, Texture.class, textureParms);
        String language = LocalSettings.getInstance().getLang();
        Locale locale = new Locale(language);
        Gdx.app.log(this.getClass().getSimpleName(), "Lang " + locale.getLanguage());
        I18NBundleLoader.I18NBundleParameter params = new I18NBundleLoader.I18NBundleParameter(locale);
        this.load("i18n/bundle", I18NBundle.class, params);
        this.finishLoading();
    }

    public Texture getPreloader() {
        return this.get(this.preloaderPath, Texture.class);
    }
}

