/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils;

import com.badlogic.gdx.graphics.Color;

public class StringUtils {
    public static String convertTimeHours(int seconds) {
        int minutes = (int)Math.floor(seconds / 60);
        int hours = (int)Math.floor(minutes / 60);
        String formattedTime = (hours < 10 ? "0" : "") + hours + ":" + ((minutes -= hours * 60) < 10 ? "0" : "") + minutes;
        return formattedTime;
    }

    public static String convertToPercent(float value, float total) {
        return (int)(100.0f - value * 100.0f / total) + " %";
    }

    public static String mark(String text, Color color) {
        return String.format("[#%s]%s[#%s]", color.toString(), text, Color.WHITE.toString());
    }

    public static String mark(String text, String color) {
        return String.format("[#%s]%s[#%s]", Color.valueOf(color), text, Color.WHITE.toString());
    }

    public static StringBuilder join(CharSequence delimiter, String[] arr) {
        if (null == delimiter || null == arr) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(delimiter).append(arr[i]);
        }
        return sb;
    }
}

