/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.tpwar.game.maps.data.AdobeAtlas;
import java.util.Map;

public class AdobeAtlasLoader
extends SynchronousAssetLoader<AdobeAtlas, AdobeAtlasParameter> {
    public AdobeAtlasLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    private AdobeAtlas get(Texture texture, String value, boolean flipX, boolean flipY) {
        TextureAtlas atlas = new TextureAtlas();
        Json json = new Json();
        AdobeAtlas data = json.fromJson(AdobeAtlas.class, value);
        for (Map.Entry<String, AdobeAtlas.FrameData> entry : data.frames.entrySet()) {
            String k = entry.getKey();
            AdobeAtlas.FrameData f = entry.getValue();
            TextureAtlas.AtlasRegion region = atlas.addRegion(k, texture, f.frame.x, f.frame.y, f.frame.w, f.frame.h);
            region.rotate = f.rotated;
            region.offsetX = f.spriteSourceSize.x;
            region.offsetY = f.spriteSourceSize.y;
            region.flip(flipX, flipY);
        }
        data.atlas = atlas;
        data.texture = texture;
        return data;
    }

    @Override
    public AdobeAtlas load(AssetManager assetManager, String fileName, FileHandle file, AdobeAtlasParameter parameter) {
        Object texturePath = file.pathWithoutExtension() + ".png";
        boolean flipX = false;
        boolean flipY = false;
        if (parameter != null) {
            if (parameter.texturePath != null) {
                texturePath = parameter.texturePath;
            }
            flipX = parameter.flipX;
            flipY = parameter.flipY;
        }
        Texture texture = assetManager.get((String)texturePath, Texture.class);
        return this.get(texture, file.readString("UTF-16LE"), flipX, flipY);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, AdobeAtlasParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        if (parameter != null) {
            if (parameter.texturePath != null) {
                deps.add(new AssetDescriptor<Texture>(parameter.texturePath, Texture.class, parameter.textureParam));
            } else {
                deps.add(new AssetDescriptor<Texture>(file.pathWithoutExtension() + ".png", Texture.class, parameter.textureParam));
            }
        } else {
            deps.add(new AssetDescriptor<Texture>(file.pathWithoutExtension() + ".png", Texture.class));
        }
        return deps;
    }

    public static class AdobeAtlasParameter
    extends AssetLoaderParameters<AdobeAtlas> {
        public String texturePath;
        public boolean flipX;
        public boolean flipY;
        public TextureLoader.TextureParameter textureParam = new TextureLoader.TextureParameter();

        public AdobeAtlasParameter(String texturePath) {
            this(texturePath, false, false);
        }

        public AdobeAtlasParameter(String texturePath, boolean flipX, boolean flipY) {
            this.texturePath = texturePath;
            this.flipX = flipX;
            this.flipY = flipY;
        }
    }
}

