/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.utils.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;

public class SkeletonDataLoader
extends AsynchronousAssetLoader<SkeletonData, SkeletonDataLoaderParameter> {
    private SkeletonData skeletonData;

    public SkeletonDataLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SkeletonDataLoaderParameter parameter) {
        this.skeletonData = null;
        Object texturePath = file.pathWithoutExtension() + ".atlas";
        float scale = 1.0f;
        if (parameter != null) {
            if (parameter.texturePath != null) {
                texturePath = parameter.texturePath;
            }
            scale = parameter.scale;
        }
        TextureAtlas atlas = manager.get((String)texturePath, TextureAtlas.class);
        SkeletonJson json = new SkeletonJson(atlas);
        json.setScale(scale);
        this.skeletonData = json.readSkeletonData(file);
    }

    @Override
    public SkeletonData loadSync(AssetManager manager, String fileName, FileHandle file, SkeletonDataLoaderParameter parameter) {
        SkeletonData skeletonData = this.skeletonData;
        this.skeletonData = null;
        return skeletonData;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SkeletonDataLoaderParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        if (parameter == null || parameter.texturePath == null) {
            deps.add(new AssetDescriptor<TextureAtlas>(file.pathWithoutExtension() + ".atlas", TextureAtlas.class));
        } else if (parameter.texturePath != null) {
            deps.add(new AssetDescriptor<TextureAtlas>(parameter.texturePath, TextureAtlas.class));
        }
        return deps;
    }

    public static class SkeletonDataLoaderParameter
    extends AssetLoaderParameters<SkeletonData> {
        public String texturePath;
        public float scale;

        public SkeletonDataLoaderParameter(float scale) {
            this.scale = scale;
        }

        public SkeletonDataLoaderParameter(String texturePath) {
            this.texturePath = texturePath;
            this.scale = 1.0f;
        }
    }
}

