/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import net.dermetfan.gdx.graphics.g2d.AnimatedSprite;

public class AnimatedActor
extends Actor {
    private Animation<TextureRegion> animation;
    private TextureRegion textureRegion;
    private float time = 0.0f;
    private boolean playing = true;

    public AnimatedActor(AnimatedSprite animatedSprite) {
        this(animatedSprite.getAnimation());
    }

    public AnimatedActor(Animation<TextureRegion> animation) {
        this.animation = animation;
        this.textureRegion = animation.getKeyFrame(0.0f);
        this.setSize(this.textureRegion.getRegionWidth(), this.textureRegion.getRegionHeight());
    }

    @Override
    public void act(float delta) {
        if (this.playing) {
            this.time += delta;
            this.textureRegion = this.animation.getKeyFrame(this.time);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.draw(this.textureRegion, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setTime(float value) {
        this.time = value;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public void stop() {
        this.playing = false;
        this.time = 0.0f;
    }
}

