/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;

public abstract class DefaultWindow
extends GameWindow {
    protected static final Assets assets = Assets.getInstance();
    protected final Model model = Model.getInstance();
    protected final Commander comander = Commander.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final SoundSystem soundSystem = SoundSystem.getInstance();
    protected ImageButton closeButton;
    @Deprecated
    private float width;
    @Deprecated
    private float height;

    @Deprecated
    public DefaultWindow(String title, int width, int height) {
        this(title);
        this.width = width;
        this.height = height;
        this.setSize(width, height);
    }

    @Deprecated
    public DefaultWindow(int width, int height) {
        this("Title");
        this.width = width;
        this.height = height;
        this.setSize(width, height);
    }

    @Override
    public float getPrefWidth() {
        if (this.width != 0.0f) {
            return this.width;
        }
        return super.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.height != 0.0f) {
            return this.height;
        }
        return super.getPrefHeight();
    }

    public DefaultWindow() {
        this("");
    }

    public DefaultWindow(String title) {
        super(title, assets.getDefaultSkin());
        this.setMovable(false);
        this.setKeepWithinStage(false);
        this.getTitleLabel().setAlignment(1);
        this.getTitleLabel().setColor(Color.valueOf("#F0E9CF"));
        this.addCloseButton();
        this.getTitleTable().pack();
        this.padTop(this.getTitleTable().getHeight() + 4.0f);
        this.padLeft(0.0f);
        this.padRight(0.0f);
        this.padBottom(0.0f);
        this.getContentTable().background(this.getSkin().getDrawable("window_background"));
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x < 0.0f || x > DefaultWindow.this.getWidth() || y < 0.0f || y > DefaultWindow.this.getHeight()) {
                    DefaultWindow.this.closeHandler();
                }
                return true;
            }
        });
    }

    public void addCloseButton() {
        Label titleLabel = this.getTitleLabel();
        Table titleTable = this.getTitleTable();
        this.closeButton = new ImageButton(this.getSkin(), "close-btn");
        titleTable.add(this.closeButton).padRight(6.0f).padTop(6.0f).padBottom(4.0f);
        this.closeButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                DefaultWindow.this.closeHandler();
            }
        });
        this.closeButton.addListener(new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.cancel();
                return true;
            }
        });
        if (titleLabel.getLabelAlign() == 1 && titleTable.getChildren().size == 2) {
            titleTable.getCell(titleLabel).padLeft(this.closeButton.getWidth());
        }
    }
}

