/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.storage.Storage;
import packet.Fraction;
import packet.Static;

public class FractionGateWindow
extends DefaultWindow {
    private Fraction.GateStatsList stats;

    public FractionGateWindow(Fraction.GateStatsList stats) {
        super("");
        this.stats = stats;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.fraction_gate"));
        this.getContentTable().pad(12.0f);
        VerticalGroup statsGroup = new VerticalGroup();
        statsGroup.space(8.0f);
        Fraction.GateStatsDto oseonStatsData = null;
        Fraction.GateStatsDto waylandStatsData = null;
        Static.StaticFaction fraction = Storage.getInstance().faction.getFactionByCode("osion");
        for (Fraction.GateStatsDto statsData : this.stats.getStatsList()) {
            if (statsData.getFractionId() == fraction.getId()) {
                oseonStatsData = statsData;
                continue;
            }
            waylandStatsData = statsData;
        }
        statsGroup.addActor(new FractionStats(oseonStatsData, waylandStatsData.getNumCaptured()));
        statsGroup.addActor(new FractionStats(waylandStatsData, oseonStatsData.getNumCaptured()));
        this.getContentTable().add(statsGroup).expand().top().left().pad(8.0f);
        Table descriptionTable = new Table();
        descriptionTable.defaults().space(20.0f);
        Label.LabelStyle style = new Label.LabelStyle(FractionGateWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label fractionDescription = new Label((CharSequence)this.model.lang.get("window.fraction_gate.description2"), style);
        fractionDescription.setWrap(true);
        descriptionTable.add(fractionDescription).width(300.0f).row();
        int needCapturedGate = this.storage.worldConfig.getNeedCapturedGate();
        int needGuardedGates = this.storage.worldConfig.getNeedGuardedGates();
        fractionDescription = new Label((CharSequence)this.model.lang.format("window.fraction_gate.description1", needCapturedGate, needGuardedGates), style);
        fractionDescription.setWrap(true);
        descriptionTable.add(fractionDescription).width(300.0f);
        this.getContentTable().add(descriptionTable).expand().top().pad(8.0f);
    }

    class FractionStats
    extends Table {
        private Assets assets = Assets.getInstance();
        private Storage storage = Storage.getInstance();

        public FractionStats(Fraction.GateStatsDto statsData, int numCapturedValue) {
            TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
            this.setBackground(this.assets.getNinePatchDrawable(atlas, "element_back", 1, 1, 1, 1));
            this.pad(6.0f);
            String color = this.storage.faction.getColor(statsData.getFractionId());
            Static.StaticFaction faction = this.storage.faction.get(statsData.getFractionId());
            Color fractionColor = Color.valueOf(color);
            Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold14, fractionColor);
            Label fractionName = new Label((CharSequence)("\u0424\u0440\u0430\u043a\u0446\u0438\u044f " + faction.getName()), style);
            this.add(fractionName).expandX().padBottom(6.0f).row();
            Table stats = new Table();
            stats.defaults().space(6.0f);
            String statsBgName = this.storage.faction.isOseon(faction.getCode()) ? "gate_stats_blue_bg" : "gate_stats_red_bg";
            stats.setBackground(this.assets.getNinePatchDrawable(atlas, statsBgName, 1, 1, 1, 1));
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
            Label numCapturedName = new Label((CharSequence)"\u0417\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u043e:", style);
            stats.add(numCapturedName).left();
            Label numCaptured = new Label((CharSequence)String.valueOf(numCapturedValue), style);
            numCaptured.setAlignment(16);
            stats.add(numCaptured).minWidth(24.0f);
            Image capturedIcon = new Image(atlas.findRegion("gate_captured_icon"));
            capturedIcon.setColor(fractionColor);
            stats.add(capturedIcon).right().row();
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
            Label numProtectedName = new Label((CharSequence)"\u041e\u0431\u043e\u0440\u043e\u043d\u044f\u0435\u0442\u0441\u044f:", style);
            stats.add(numProtectedName);
            Label numProtected = new Label((CharSequence)String.valueOf(statsData.getNumProtected()), style);
            numProtected.setAlignment(16);
            stats.add(numProtected).minWidth(24.0f);
            Image protectedIcon = new Image(atlas.findRegion("gate_protected_icon"));
            protectedIcon.setColor(fractionColor);
            stats.add(protectedIcon);
            stats.pad(12.0f);
            this.add(stats);
        }
    }
}

