/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.tpwar.game.windows.WindowManager;

public abstract class GameWindow
extends Dialog {
    public GameWindow(String title, Skin skin, String windowStyleName) {
        super(title, skin, windowStyleName);
        this.initialize();
    }

    public GameWindow(String title, Skin skin) {
        super(title, skin);
        this.initialize();
    }

    public GameWindow(String title, Window.WindowStyle windowStyle) {
        super(title, windowStyle);
        this.initialize();
    }

    private void initialize() {
        this.ignoreTouchDown = new InputListener();
    }

    @Override
    public void hide(Action action) {
        this.setTouchable(Touchable.disabled);
        super.hide(action);
    }

    public void setTitle(String title) {
        this.getTitleLabel().setText(title);
    }

    public void moveToCenter() {
        Stage parent = this.getStage();
        if (parent != null) {
            this.setPosition(Math.round((parent.getWidth() - this.getWidth()) / 2.0f), Math.round((parent.getHeight() - this.getHeight()) / 2.0f));
        }
    }

    public abstract void openHandler();

    public void closeHandler() {
        this.clearListeners();
        WindowManager.getInstance().close(this);
    }
}

