/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Colors;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import packet.Avatars;

public class LevelUpWindow
extends GameWindow {
    protected static final Assets assets = Assets.getInstance();
    protected final Commander comander = Commander.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final Model model = Model.getInstance();
    private Avatars.LevelUp levelReward;

    public LevelUpWindow(Avatars.LevelUp levelReward) {
        super("", assets.getDefaultSkin());
        this.levelReward = levelReward;
    }

    @Override
    public void openHandler() {
        this.setMovable(false);
        this.setKeepWithinStage(false);
        this.setModal(true);
        this.setClip(false);
        this.setTransform(true);
        this.padLeft(0.0f);
        this.padRight(0.0f);
        this.padBottom(0.0f);
        this.getContentTable().background(this.getSkin().getDrawable("window_background"));
        Table main = new Table();
        main.defaults().space(20.0f);
        this.getContentTable().add(main).expandX().padLeft(20.0f).padRight(20.0f).padTop(40.0f).padBottom(10.0f);
        Label.LabelStyle congratulationsStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arialBold16, Color.valueOf("#EFD774"));
        Label congratulations = new Label((CharSequence)this.model.lang.get("window.level_up"), congratulationsStyle);
        congratulations.setAlignment(1);
        main.add(congratulations).expandX().row();
        Label.LabelStyle descrStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label description = new Label((CharSequence)this.model.lang.get("window.level_up.message"), descrStyle);
        description.setWrap(true);
        description.setAlignment(1);
        main.add(description).width(240.0f).row();
        main.add(this.createRewardBlock()).expandX().fill();
        this.pack();
        TextureAtlas atlas = assets.getCommonAtlas();
        Image header = new Image(atlas.findRegion("level_up_header"));
        header.setY(this.getPrefHeight() - 52.0f);
        header.setX((this.getPrefWidth() - header.getWidth()) / 2.0f + 2.0f);
        this.addActor(header);
        Label.LabelStyle levelStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().centryGothicBold40, Color.WHITE);
        Label level = new Label((CharSequence)String.valueOf(this.levelReward.getLevel()), levelStyle);
        level.setAlignment(1);
        level.setX((this.getPrefWidth() - level.getWidth()) / 2.0f + 2.0f);
        level.setY(header.getY() + 52.0f);
        this.addActor(level);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x < 0.0f || x > LevelUpWindow.this.getWidth() || y < 0.0f || y > LevelUpWindow.this.getHeight()) {
                    LevelUpWindow.this.closeHandler();
                }
                return true;
            }
        });
        SoundSystem.getInstance().fx.play("sound/music/14 - New level.mp3");
    }

    private Table createRewardBlock() {
        Color color = Color.valueOf("#F0E9CF");
        Label.LabelStyle labelStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arialBold14, color);
        Label rewardLabel = new Label((CharSequence)"Reward", labelStyle);
        Table hEnergy = new Table();
        labelStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arial14, color);
        Label energyName = new Label((CharSequence)"Energy:", labelStyle);
        hEnergy.add(energyName).expandX().left();
        Table hPoints = new Table();
        Label pointsName = new Label((CharSequence)"Points:", labelStyle);
        hPoints.add(pointsName).expandX().left();
        Image icon = new Image(assets.getCommonAtlas().findRegion("energy_icon_small"));
        hEnergy.add(icon).padRight(4.0f);
        labelStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arialBold14, Colors.CRYSTALS_COLOR);
        Label energy = new Label((CharSequence)String.valueOf(this.levelReward.getEnergy()), labelStyle);
        hEnergy.add(energy);
        labelStyle = new Label.LabelStyle(LevelUpWindow.assets.getFont().arialBold14, color);
        Label points = new Label((CharSequence)String.valueOf(this.levelReward.getUpgradePoints()), labelStyle);
        hPoints.add(points);
        Table table = new Table();
        table.defaults().space(5.0f);
        table.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 10, 10, 6, 6));
        table.add(rewardLabel).padBottom(5.0f).row();
        table.add(hPoints).growX().row();
        table.add(hEnergy).growX().row();
        return table;
    }
}

