/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BuildingData;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.action.AvatarSlotWithButton;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.guild.TaskTypeData;
import packet.Static;
import packet.Transport;

public class MineWindow
extends DefaultWindow
implements MessageListener {
    private BitmapFont arial14Font = (BitmapFont)assets.get("fonts/arial_14_bold.fnt");
    private TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
    private Static.StaticBuilding data;
    private BuildingData buildingData;
    private Image buildingIcon;
    private AvatarSlotWithButton avatarSlot;
    private TextButton actionBtn;
    private Label decription;
    private Label status;
    private Table leftSide;
    private Table rightSide;
    private Container<Actor> slotContainer;

    public MineWindow(Static.StaticBuilding data) {
        super("");
        this.data = data;
    }

    @Override
    public void openHandler() {
        TaskTypeData taskType;
        this.setTitle(this.model.lang.get("window.mine"));
        Table main = new Table();
        main.defaults().space(10.0f);
        this.getContentTable().add(main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        this.leftSide = new Table();
        this.rightSide = new Table();
        main.add(this.leftSide);
        main.add(this.rightSide).fill().top();
        this.slotContainer = new Container();
        this.leftSide.add(this.slotContainer).size(170.0f, 275.0f);
        this.buildingData = this.model.zone.getBuildingData(this.data.getId());
        this.actionBtn = new TextButton(this.model.lang.get("window.mine.capture"), this.getSkin(), "yellow-btn");
        this.actionBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MineWindow.this.buildingData == null) {
                    MineWindow.this.closeHandler();
                } else if (MineWindow.this.buildingData.avatar == null) {
                    MineWindow.this.comander.MineActionDig(MineWindow.this.buildingData.id);
                    MineWindow.this.soundSystem.fx.play("sound/fx/19. Capture_a_Mine.mp3");
                } else {
                    MineWindow.this.comander.MineActionStop(MineWindow.this.buildingData.id);
                    MineWindow.this.soundSystem.fx.play("sound/fx/21. Leave portal, mine, digg.mp3");
                }
            }
        });
        this.getButtonTable().add(this.actionBtn);
        this.getButtonTable().padBottom(6.0f);
        this.buildingIcon = Component.getImage(this.atlas, "building_mine");
        Label.LabelStyle descriptionStyle = new Label.LabelStyle();
        descriptionStyle.font = this.arial14Font;
        descriptionStyle.fontColor = Color.valueOf("#F0E9CF");
        String text = this.model.lang.format("window.mine.description", TimeUtils.convertShortMinutes(this.data.getTimeout()), this.data.getValue());
        this.decription = new Label((CharSequence)text, descriptionStyle);
        this.decription.setWrap(true);
        this.decription.setAlignment(10);
        this.rightSide.add(this.decription).width(250.0f).expandY().top().padTop(20.0f).row();
        descriptionStyle = new Label.LabelStyle(descriptionStyle);
        descriptionStyle.fontColor = Color.valueOf("#EFD774");
        this.status = new Label((CharSequence)"", descriptionStyle);
        this.status.setWrap(true);
        this.status.setAlignment(1);
        this.rightSide.add(this.status).width(250.0f).expand().center().row();
        Table info = new Table();
        Label timeoutLabel = new Label((CharSequence)this.model.lang.get("window.mine.timeout"), descriptionStyle);
        info.add(timeoutLabel).expandX().left();
        AvatarData avatar = this.model.player.selectedAvatar;
        Static.StaticGuild guild = avatar.getGuild();
        int timeout = this.data.getTimeout();
        if (guild != null && (taskType = this.storage.taskType.get(guild.getTaskTypeId())).isMine()) {
            Static.StaticGuildRank rank = avatar.getGuildRank();
            timeout = rank.getModifier() * 60;
        }
        Label timeoutNumber = new Label((CharSequence)TimeUtils.convertShortMinutes(timeout), descriptionStyle);
        timeoutNumber.setAlignment(16);
        info.add(timeoutNumber).width(50.0f).right().colspan(2).row();
        Label rewardLabel = new Label((CharSequence)this.model.lang.get("window.mine.reward"), descriptionStyle);
        info.add(rewardLabel).expandX().left();
        Label rewardNumber = new Label((CharSequence)String.valueOf(this.data.getValue()), descriptionStyle);
        rewardNumber.setAlignment(16);
        info.add(rewardNumber).right();
        Image energyIcon = Component.getImage(this.atlas, "energy_icon");
        energyIcon.setScale(0.8f);
        info.add(energyIcon).width(25.0f).right().top();
        this.rightSide.add(info).expand().fill();
        this.update();
        this.model.addListener(this, Cmd.BuildingUpdate.getCode());
        this.model.addListener(this, Cmd.BuildingStatus.getCode());
        this.model.addListener(this, Cmd.BuildingInfoUpdate.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.update();
    }

    private void update() {
        boolean hasQuestActiveGoal;
        AvatarData avatar = this.model.player.selectedAvatar;
        boolean buildingAvail = this.buildingData == null || avatar.checkBuildingAvail(this.buildingData.id);
        boolean bl = hasQuestActiveGoal = avatar.getNumCreatedUnits() == 3 && avatar.hasQuestActiveGoal("mine");
        if (!buildingAvail) {
            this.status.setText(hasQuestActiveGoal ? "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u043f\u043e \u043c\u0438\u0441\u0441\u0438\u0438!" : "\u0428\u0430\u0445\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430!");
        }
        this.actionBtn.setDisabled(!(buildingAvail |= hasQuestActiveGoal));
        if (this.buildingData != null && this.buildingData.hasAvatar()) {
            this.setAvatar(this.buildingData.avatar);
            if (this.buildingData.hasAvatar() && this.buildingData.avatar.id == avatar.id) {
                this.actionBtn.setText(this.model.lang.get("window.mine.liberate"));
            } else {
                this.actionBtn.setDisabled(true);
            }
        } else {
            this.setBuilding();
            this.actionBtn.setText(this.model.lang.get("window.mine.capture"));
        }
    }

    private void setAvatar(AvatarData avatar) {
        this.buildingIcon.remove();
        if (this.avatarSlot != null) {
            this.avatarSlot.remove();
        }
        this.avatarSlot = new AvatarSlotWithButton(avatar);
        this.slotContainer.setActor(this.avatarSlot);
    }

    private void setBuilding() {
        if (this.avatarSlot != null) {
            this.avatarSlot.remove();
        }
        this.slotContainer.setActor(this.buildingIcon);
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }
}

