/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import packet.Static;

public class TimeWarpWindow
extends DefaultWindow {
    private WindowManager windowManager = WindowManager.getInstance();
    private Static.StaticTimeWarpType type;
    private long avatarId;

    public TimeWarpWindow(Static.StaticTimeWarpType type, long avatarId) {
        super("");
        this.type = type;
        this.avatarId = avatarId;
    }

    @Override
    public void openHandler() {
        this.setTitle("\u0418\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
        Table main = new Table();
        main.defaults().space(10.0f);
        this.getContentTable().add(main).expandX().padTop(10.0f).padBottom(10.0f);
        Image icon = new Image(assets.getCommonAtlas().findRegion(this.type.getSacle() < 0 ? "time_warp_decel" : "time_warp_accel"));
        main.add(icon).row();
        String scaleText = this.type.getSacle() < 0 ? "\u0443\u0432\u0435\u043b\u0438\u0447\u0435\u0442" : "\u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442";
        String text = "\u042d\u0442\u043e\u0442 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442 " + scaleText + " \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u044e\u043d\u0438\u0442\u043e\u0432 \u043d\u0430 30% \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 24 \u0447\u0430\u0441\u043e\u0432. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c 20 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432";
        Label.LabelStyle style = new Label.LabelStyle(TimeWarpWindow.assets.getFont().arial14, Color.WHITE);
        Label label = new Label((CharSequence)text, style);
        label.setAlignment(1);
        label.setWrap(true);
        main.add(label).width(200.0f);
        TextButton buyTimeWarpBtn = new TextButton("\u041a\u0443\u043f\u0438\u0442\u044c", TimeWarpWindow.assets.getUi().buyButtonStyle);
        buyTimeWarpBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (FinanceManager.checkCrystals(TimeWarpWindow.this.model.player, 20)) {
                    FinanceManager.showConfirmWindow(20, new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            if (TimeWarpWindow.this.model.player.selectedAvatar.id != TimeWarpWindow.this.avatarId) {
                                TimeWarpWindow.this.soundSystem.fx.play(TimeWarpWindow.this.type.getSacle() < 0 ? "sound/fx/26. Buy_time_slower.mp3" : "sound/fx/25. Buy_time_booster.mp3");
                            }
                            TimeWarpWindow.this.comander.TimeWarpActionBuy(TimeWarpWindow.this.avatarId, TimeWarpWindow.this.type.getId());
                            TimeWarpWindow.this.windowManager.closeCurrentWindow();
                            TimeWarpWindow.this.closeHandler();
                        }
                    });
                }
            }
        });
        this.getButtonTable().add(buyTimeWarpBtn);
        this.getButtonTable().padBottom(6.0f);
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
    }
}

