/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Queue;
import com.tpwar.events.EventDispatcher;
import com.tpwar.game.display.Resizeble;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.sound.SoundSystem;

public class WindowManager
extends EventDispatcher<GameWindow>
implements Resizeble {
    private static final WindowManager instance = new WindowManager();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private Stage stage;
    private Queue<GameWindow> windowsQueue = new Queue();
    private Queue<GameWindow> openedWindows = new Queue();

    public boolean hasOpenedWindow() {
        return this.openedWindows.size > 0;
    }

    public boolean hasOpenedWindowByClass(Class<? extends GameWindow> clazz) {
        for (GameWindow window : this.openedWindows) {
            if (!clazz.isAssignableFrom(window.getClass())) continue;
            return true;
        }
        return false;
    }

    public void open(GameWindow window) {
        this.open(window, false);
    }

    public void open(GameWindow window, boolean onTop) {
        if (this.stage == null) {
            Gdx.app.log(this.getClass().getSimpleName(), "Error open window");
            return;
        }
        if (this.openedWindows.size == 0 || onTop) {
            this.openWindow(window);
        } else {
            this.windowsQueue.addLast(window);
        }
    }

    private void openWindow(GameWindow window) {
        this.openedWindows.addLast(window);
        window.openHandler();
        window.show(this.stage);
        window.moveToCenter();
        this.dispatch(1, window);
        this.soundSystem.fx.play("sound/fx/1. Open_Window.mp3", false);
    }

    @Override
    public void resize(int width, int height) {
        for (GameWindow window : this.openedWindows) {
            window.moveToCenter();
        }
    }

    public void close(GameWindow window) {
        window.hide();
        this.openedWindows.removeValue(window, true);
        if (this.openedWindows.size == 0 && this.windowsQueue.size > 0) {
            this.openWindow(this.windowsQueue.removeFirst());
        }
        this.dispatch(2, window);
        this.soundSystem.fx.play("sound/fx/2. Close_Window.mp3", false);
    }

    public void closeCurrentWindow() {
        if (this.openedWindows.size > 0) {
            GameWindow window = this.openedWindows.last();
            window.closeHandler();
        }
    }

    public void closeAll() {
        for (GameWindow window : this.openedWindows) {
            window.closeHandler();
        }
        this.openedWindows.clear();
        this.windowsQueue.clear();
        this.dispatch(3, null);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public static WindowManager getInstance() {
        return instance;
    }
}

