/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.action;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.action.AvatarSlotWithButton;
import com.tpwar.game.windows.action.BattleWidget;

public class ActionWindow
extends DefaultWindow {
    private Model model = Model.getInstance();
    private ScrollPane scrollPane;
    private Table content;
    private Array<AvatarData> avatars;
    private Array<BattleMarkData> battles;

    public ActionWindow(Array<AvatarData> avatars, Array<BattleMarkData> battles) {
        super("");
        this.avatars = avatars;
        this.battles = battles;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.action"));
        Table main = new Table();
        this.getContentTable().add(main).expand().left().pad(10.0f, 20.0f, 10.0f, 20.0f).top();
        this.content = new Table();
        this.content.align(8);
        this.addActor(this.content);
        for (AvatarData avatar : this.avatars) {
            AvatarSlotWithButton as = new AvatarSlotWithButton(avatar);
            this.content.add(as).width(160.0f).padLeft(10.0f).left();
        }
        for (BattleMarkData battle : this.battles) {
            this.content.add(new BattleWidget(battle)).height(230.0f).width(160.0f).padLeft(10.0f).left().top();
        }
        this.scrollPane = new ScrollPane((Actor)this.content);
        this.scrollPane.layout();
        Table container = new Table();
        container.add(this.scrollPane).size(640.0f, 300.0f).expand().top();
        main.add(container).grow().left().top();
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
    }
}

