/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.action;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import packet.Static;

public class AvatarSlot
extends Table {
    protected final Assets assets = Assets.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final Model model = Model.getInstance();
    protected final Color nameColor = Color.valueOf("#F0E9CF");
    protected final Color numColor = Color.valueOf("#EFD774");
    protected AvatarData avatar;
    protected Table tableOfControls;
    private boolean isRatingSlot;

    public AvatarSlot(AvatarData avatar, boolean isRatingSlot) {
        int type;
        TextureRegionDrawable drawable;
        this.avatar = avatar;
        this.isRatingSlot = isRatingSlot;
        TextureAtlas elements = (TextureAtlas)this.assets.get("entity/entity_elements.atlas");
        Static.StaticFaction fraction = this.storage.faction.get(avatar.fractionId);
        boolean isOseon = this.storage.faction.isOseon(fraction.getCode());
        String nameBack = isOseon ? "fraction_back0001" : "fraction_back0002";
        Table nameTable = new Table();
        nameTable.setBackground(this.assets.getNinePatchDrawable(this.assets.getCommonAtlas(), nameBack, 15, 15, 0, 4));
        Label.LabelStyle nameStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
        Object nickName = !this.model.isItAprilFoolsDay() ? avatar.getFullName() : "Dude [" + avatar.level + "]";
        Label name = new Label((CharSequence)nickName, nameStyle);
        if (avatar.hasTimeWarp() && (drawable = this.assets.getDrawable(elements, "time_warp_icon000" + (type = avatar.timeWarpTypeId == 2L ? 2 : 1))).getRegion() != null) {
            Image timeWarp = new Image(drawable);
            nameTable.add(timeWarp).expand().right();
        }
        nameTable.add(name).expand().top();
        this.add(nameTable).minWidth(146.0f).space(6.0f).row();
        this.tableOfControls = new Table();
        String iconName = avatar.getImageName() + "_icon";
        Container<Image> avatarImage = new Container<Image>(new Image(this.assets.getDrawable(this.assets.getCommonAtlas(), iconName)));
        avatarImage.align(2);
        this.add(new Stack(avatarImage, this.tableOfControls)).expandX().fillX().top().height(136.0f).row();
        Table icons = new Table();
        if (avatar.treasureId > 0L) {
            Image treasureMapIcon = new Image(this.assets.getDrawable(elements, "treasure_map_icon"));
            icons.add(treasureMapIcon).expand().left().top();
        }
        if (avatar.hasGuild()) {
            Static.StaticGuildRank rank = this.storage.guildRanks.get(avatar.guildRankId);
            int frame = GuildStorage.getGuildRankFrame(rank);
            TextureRegion guildTexture = this.assets.extractRegions(elements, "guild_icon").get(frame);
            guildTexture.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image guild = new Image(new TextureRegionDrawable(guildTexture));
            guild.setScale(0.85f);
            icons.add(guild).expand().right().top().padRight(24.0f);
        }
        this.tableOfControls.add(icons).expand().fillX().top().row();
        Table stats = new Table();
        stats.defaults().space(2.0f);
        if (!isRatingSlot) {
            this.addStatField(stats, this.model.lang.get("window.profile.units"), avatar.numUnits, this.numColor, this.numColor);
        } else {
            this.addStatField(stats, this.model.lang.get("window.profile.experiance"), avatar.experience, this.numColor, this.numColor);
        }
        this.addStatField(stats, this.model.lang.get("window.profile.wins"), avatar.wins, this.nameColor, this.numColor);
        this.addStatField(stats, this.model.lang.get("window.profile.defeats"), avatar.defeats, this.nameColor, this.numColor);
        this.addStatField(stats, this.model.lang.get("window.profile.draws"), avatar.draws, this.nameColor, this.numColor);
        this.addStatField(stats, this.model.lang.get("window.profile.escapes"), avatar.escape, this.nameColor, this.numColor);
        this.addStatField(stats, this.model.lang.get("window.profile.win_streak"), avatar.winsStreak, this.nameColor, this.numColor);
        this.add(stats);
    }

    private Label addStatField(Table table, String name, Object value, Color textColor, Color color) {
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arial14, textColor);
        Label text = new Label((CharSequence)name, style);
        table.add(text).expandX().fillX().left();
        Label.LabelStyle numStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, color);
        Label num = new Label((CharSequence)String.valueOf(value), numStyle);
        num.setAlignment(16);
        table.add(num).expandX().right().row();
        return num;
    }
}

