/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.action;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.AvatarManager;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.TimeWarpWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.action.AvatarSlot;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;

public class AvatarSlotWithButton
extends AvatarSlot {
    private final Commander commander = Commander.getInstance();
    private final Model model = Model.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    public ImageButton attackBtn;
    public ImageButton inviteBtn;
    public ImageButton messageBtn;
    public ImageButton timeUpBtn;
    public ImageButton timeDownBtn;

    public AvatarSlotWithButton(AvatarData avatar) {
        this(avatar, false);
    }

    public AvatarSlotWithButton(final AvatarData avatar, boolean isRatingSlot) {
        super(avatar, isRatingSlot);
        TextureAtlas atlas = this.assets.getCommonAtlas();
        AvatarData selectedAvatar = this.model.player.selectedAvatar;
        this.inviteBtn = Component.getImageButton(atlas, "clan_btn");
        this.inviteBtn.setVisible(selectedAvatar.isClanMaster() && selectedAvatar.fractionId == avatar.fractionId);
        this.inviteBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarSlotWithButton.this.commander.ClanActionInvate(avatar.name);
                AvatarSlotWithButton.this.windowManager.open(WarningWindow.create(WarningWindow.Type.INFO, "window.clan.invite", "window.clan.invite.info", "window.confirm.ok"), true);
            }
        });
        this.tableOfControls.add(this.inviteBtn).expand().right().padRight(6.0f).bottom().padBottom(-6.0f).row();
        Table bottomRow = new Table();
        this.attackBtn = Component.getImageButton(atlas, "attack_btn");
        bottomRow.add(this.attackBtn).expand().padBottom(4.0f).left();
        boolean canAttack = this.model.player.selectedAvatar.canAttack(avatar, this.storage.planet.get(selectedAvatar.planetId));
        this.attackBtn.setTouchable(canAttack ? Touchable.enabled : Touchable.disabled);
        this.attackBtn.setDisabled(!canAttack);
        this.attackBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarManager.attack(avatar);
            }
        });
        this.timeUpBtn = Component.getImageButton(atlas, "timewarp_up_btn");
        this.timeUpBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarSlotWithButton.this.windowManager.open(new TimeWarpWindow(AvatarSlotWithButton.this.storage.timeWarp.get("acceleration"), avatar.id), true);
            }
        });
        bottomRow.add(this.timeUpBtn).expand();
        this.timeDownBtn = Component.getImageButton(atlas, "timewarp_down_btn");
        this.timeDownBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarSlotWithButton.this.windowManager.open(new TimeWarpWindow(AvatarSlotWithButton.this.storage.timeWarp.get("deceleration"), avatar.id), true);
            }
        });
        bottomRow.add(this.timeDownBtn).expand();
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = this.assets.getDrawable(atlas, "message_btn0001");
        btnStyle.down = this.assets.getDrawable(atlas, "message_btn0003");
        btnStyle.disabled = this.assets.getDrawable(atlas, "message_btn0004");
        this.messageBtn = new ImageButton(btnStyle);
        this.messageBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AvatarSlotWithButton.this.windowManager.open(new MessageWindow(avatar.name), true);
            }
        });
        bottomRow.add(this.messageBtn).expand().padRight(6.0f);
        this.tableOfControls.add(bottomRow).expand().fillX().bottom();
    }
}

